<?php
/**
 * Clase ContTipoTesiser para TipoTesis
 *
 * @package    IM
 * @subpackage TipoTesisCT
 * @author     Willy
 * @version    SVN: $Id: TipoTesisCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class TipoTesisCT implements interfaceCT{
  /**
  * Funcin para Guardar el  TipoTesis
  *
  * @param $o_TipoTesisBean, objeto bean de TipoTesis
  * @return booleam
  */
  public function guardar(&$o_TipoTesisBean){ 
    $o_TipoTesisDP = new TipoTesisDP($o_TipoTesisBean);
    return $o_TipoTesisDP->save(); 
  }
  
  /**
  * Funcin para Modificar el  TipoTesis
  *
  * @param $o_TipoTesisBean, objeto bean de TipoTesis
  * @return booleam
  */
  public function modificar(&$o_TipoTesisBean){
    $o_TipoTesisDP = new TipoTesisDP($o_TipoTesisBean);
    return $o_TipoTesisDP->update();
  }
  
  /**
  * Funcin para Eliminar el  TipoTesis
  *
  * @param $o_TipoTesisBean, objeto bean de TipoTesis
  * @return booleam
  */
  public function eliminar($o_TipoTesisBean){ 
   $o_TipoTesisDP = new TipoTesisDP($o_TipoTesisBean);
    return $o_TipoTesisDP->delete();
  }
  
  /**
  * Funcin para Seleccionar el  TipoTesis
  *
  * @param $o_TipoTesisBeans, objeto bean de TipoTesis
  * @return booleam
  */
  public function seleccionar($o_TipoTesisBean){
  
    $o_TipoTesisDP = new TipoTesisDP($o_TipoTesisBean);        
    if($o_TipoTesisBean->getTipoTesisId()){
      return $o_TipoTesisDP->selectByPk();
    }else{
      return $o_TipoTesisDP->select();
    }
      
  }
  
}