<?php
/**
 * Clase ContTipoNegocioer para TipoNegocio
 *
 * @package    IM
 * @subpackage TipoNegocioCT
 * @author     Willy
 * @version    SVN: $Id: TipoNegocioCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class TipoNegocioCT implements interfaceCT{
  /**
  * Funcin para Guardar el  TipoNegocio
  *
  * @param $o_TipoNegocioBean, objeto bean de TipoNegocio
  * @return booleam
  */
  public function guardar(&$o_TipoNegocioBean){ 
    
    $o_TipoNegocioDP = new TipoNegocioDP($o_TipoNegocioBean);
    return $o_TipoNegocioDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  TipoNegocio
  *
  * @param $o_TipoNegocioBean, objeto bean de TipoNegocio
  * @return booleam
  */
  public function modificar(&$o_TipoNegocioBean){
    
    $o_TipoNegocioDP = new TipoNegocioDP($o_TipoNegocioBean);
    return $o_TipoNegocioDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  TipoNegocio
  *
  * @param $o_TipoNegocioBean, objeto bean de TipoNegocio
  * @return booleam
  */
  public function eliminar($o_TipoNegocioBean){ 
    $o_TipoNegocioDP = new TipoNegocioDP($o_TipoNegocioBean);
    return $o_TipoNegocioDP->delete();
  }
  
  
  public function totalRegistros($o_TipoNegocioBean){
    $o_TipoNegocioBeanDP = new TipoNegocioDP($o_TipoNegocioBean);
    return $o_TipoNegocioBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  TipoNegocio
  *
  * @param $o_TipoNegocioBeans, objeto bean de TipoNegocio
  * @return booleam
  */
  public function seleccionar($o_TipoNegocioBean){
  
    $o_TipoNegocioDP = new TipoNegocioDP($o_TipoNegocioBean);
    if($o_TipoNegocioBean->getTipoNegocioId()){
      return $o_TipoNegocioDP->selectByPk();
    }else{
      return $o_TipoNegocioDP->select();
    }
      
  }
  
}

