<?php
/**
 * Clase ContDocumentoer para Documento
 *
 * @package    IM
 * @subpackage DocumentoCT
 * @author     Willy
 * @version    SVN: $Id: DocumentoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class DocumentoCT implements interfaceCT{
  /**
  * Funcin para Guardar el  Documento
  *
  * @param $o_DocumentoBean, objeto bean de Documento
  * @return booleam
  */
  public function guardar(&$o_DocumentoBean){ 
    
    $o_DocumentoDP = new DocumentoDP($o_DocumentoBean);
    return $o_DocumentoDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  Documento
  *
  * @param $o_DocumentoBean, objeto bean de Documento
  * @return booleam
  */
  public function modificar(&$o_DocumentoBean){
    
    $o_DocumentoDP = new DocumentoDP($o_DocumentoBean);
    return $o_DocumentoDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  Documento
  *
  * @param $o_DocumentoBean, objeto bean de Documento
  * @return booleam
  */
  public function eliminar($o_DocumentoBean){ 
    $o_DocumentoDP = new DocumentoDP($o_DocumentoBean);
    return $o_DocumentoDP->delete();
  }
  
  
  public function totalRegistros($o_DocumentoBean){
    $o_DocumentoBeanDP = new DocumentoDP($o_DocumentoBean);
    return $o_DocumentoBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  Documento
  *
  * @param $o_DocumentoBeans, objeto bean de Documento
  * @return booleam
  */
  public function seleccionar($o_DocumentoBean){
  
    $o_DocumentoDP = new DocumentoDP($o_DocumentoBean);
    if($o_DocumentoBean->getDocumentoId()){
      return $o_DocumentoDP->selectByPk();
    }else{
      return $o_DocumentoDP->select();
    }
      
  }
  
}