<?php

/**
* Clase Dispacher para TipoColaboradorRol
*
* @package IM
* @subpackage TipoColaboradorRolDP
* @author Willy
* @version SVN: : TipoColaboradorRolDP.class.php,v 1.1 2009/05/24 17:57:02 Exp $
*/
class TipoColaboradorRolDP implements interfaceDP {

  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto TipoColaboradorRolBean
  *
  * @param TipoColaboradorRolBean $o_TipoColaboradorRolBean
  */
  public function __construct(TipoColaboradorRolBean $o_TipoColaboradorRolBean){
  
    $this->o_Bean = $o_TipoColaboradorRolBean;
    
  }
  
  /**
  * Retorna el objeto TipoColaboradorRolBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new TipoColaboradorRolBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      if($this->getObjetoBean()->getIdTipoColaborador()) : $a_Fields['IdTipoColaborador'] = ($this->getObjetoBean()->getIdTipoColaborador()); endif;
      if($this->getObjetoBean()->getIdRol()) : $a_Fields['IdRol'] = ($this->getObjetoBean()->getIdRol()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO cr_tipocolaborador_rol  (".$sStringField.")
                      VALUES (".$sStringValue.");";
      echo $sql;
      $iResultSave = $con->query($sql);
      
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
  
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getIdTipoColaborador()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getIdTipoColaborador()) : $a_Fields['IdTipoColaborador'] = ($this->getObjetoBean()->getIdTipoColaborador()); endif;
      if($this->getObjetoBean()->getIdRol()) : $a_Fields['IdRol'] = ($this->getObjetoBean()->getIdRol()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_tipocolaborador_rol  SET
                  ".$sString."
            WHERE 1 AND IdTipoColaborador= '".$this->getObjetoBean()->getIdTipoColaborador()."' ";
      
      $result = $con->query($sql);
      
      //echo $sql;           
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
    
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    /*
      $o_TipoColaboradorRol = new TipoColaboradorRol();
      
      if($this->getObjetoBean()->getIdTipoRepresentante()){
          $o_TipoColaboradorRol->setIdTipoRepresentante($this->getObjetoBean()->getIdTipoRepresentante());
      }
      $iResultDelete = $o_TipoColaboradorRol->delete();
      if($iResultDelete > 0){
          return true;
      }else{
          return false;
      }    
    */
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    //$orden = $this->buildOrderByField();
    if(trim($orden) =='') $orden = "ORDER BY IdTipoColaborador DESC";
    $con = Conexion::getConexion();
    $sql = "SELECT * 
    		FROM cr_tipocolaborador_rol
            WHERE Eliminado <> '1' ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    //echo $sql;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    //echo $sql;
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }  
  
  
  /**
  * Retorna un objeto TipoColaboradorRolBean
  *
  * @return Object
  */
   public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_tipocolaborador_rol WHERE 1 and IdTipoColaborador='".$this->getObjetoBean()->getIdTipoColaborador()."' ";
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    
    //echo $sql;
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto TipoColaboradorRolBean
  *
  * @param Object $o_Propel
  * @return TipoColaboradorRolBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_TipoColaboradorRolBean = new TipoColaboradorRolBean();
    
    $o_TipoColaboradorRolBean->setIdTipoColaborador($o_Propel->IdTipoColaborador);
    $o_TipoColaboradorRolBean->setIdRol($o_Propel->IdRol);
    $o_TipoColaboradorRolBean->setDescripcion($o_Propel->Descripcion);
    $o_TipoColaboradorRolBean->setEliminado($o_Propel->Eliminado); 
    $o_TipoColaboradorRolBean->setInsertTipoColaborador($o_Propel->InsertTipoColaborador); 
    $o_TipoColaboradorRolBean->setFiltroColaborador($o_Propel->FiltroColaborador); 
            
    return $o_TipoColaboradorRolBean;    
    
  }
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    
    $sql = "SELECT * FROM cr_tipocolaborador_rol WHERE Eliminado <> '1' ".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    
    //echo $sql;
    return $num_rows;
    
  }
  
   private function buildConsult(){
    
    $where = "";
    
    if($this->getObjetoBean()->getIdTipoColaborador()){
       $where .= " AND IdTipoNegocio  = '".$this->getObjetoBean()->getIdTipoColaborador()."'";
    }
    
    if($this->getObjetoBean()->getDescripcion()){
       $where .= " AND Descripcion like '%".$this->getObjetoBean()->getDescripcion()."%'";
    }
    if($this->getObjetoBean()->getIdRol()){
        $where .= " AND IdRol  = '".$this->getObjetoBean()->getIdRol()."'";
    }
   
    return $where;
    
  }
    
}

