<?php

/**
* Clase Dispacher para Sucursal
*
* @package IM
* @subpackage SucursalDP
* @author Willy
* @version SVN: : SucursalDP.class.php,v 1.1 2009/06/09 15:08:14 Exp $
*/
class SucursalDP implements interfaceDP {
  private static $fieldNames = array (
    'Descripcion' => 'Descripcion'
	);
  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto SucursalBean
  *
  * @param SucursalBean $o_SucursalBean
  */
  public function __construct(SucursalBean $o_SucursalBean){
  
    $this->o_Bean = $o_SucursalBean;
    
  }
  
  /**
  * Retorna el objeto SucursalBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new SucursalBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  
  public function save(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getDireccion()) : $a_Fields['Direccion'] = ($this->getObjetoBean()->getDireccion()); endif;
      if($this->getObjetoBean()->getFechaSaldoIni()) : $a_Fields['FechaSaldoIni'] = ($this->getObjetoBean()->getFechaSaldoIni()); endif;
      if($this->getObjetoBean()->getTelefono()) : $a_Fields['Telefono'] = ($this->getObjetoBean()->getTelefono()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getIdAdministrador()) : $a_Fields['IdAdministrador'] = ($this->getObjetoBean()->getIdAdministrador()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      if($this->getObjetoBean()->getfechaInicioBalance()) : $a_Fields['fechaInicioBalance'] = ($this->getObjetoBean()->getfechaInicioBalance()); endif;
	  if($this->getObjetoBean()->getSaldoDisponibleIni()) : $a_Fields['SaldoDisponibleIni'] = ($this->getObjetoBean()->getSaldoDisponibleIni()); endif;	     
  
      
       $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO cr_sucursal (".$sStringField.")
                      VALUES (".$sStringValue.");";
       //echo $sql;
      $iResultSave = $con->query($sql);
      $IdSucursal = $con->lastInsertId();
      $this->getObjetoBean()->setIdSucursal($IdSucursal);
      
      
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
  
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getIdSucursal()){
    	
      $con = Conexion::getConexion();
      
      $a_Fields = array();  
      
      if($this->getObjetoBean()->getIdSucursal()) : $a_Fields['IdSucursal'] = ($this->getObjetoBean()->getIdSucursal()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getDireccion()) : $a_Fields['Direccion'] = ($this->getObjetoBean()->getDireccion()); endif;
      if($this->getObjetoBean()->getTelefono()) : $a_Fields['Telefono'] = ($this->getObjetoBean()->getTelefono()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getIdAdministrador()) : $a_Fields['IdAdministrador'] = ($this->getObjetoBean()->getIdAdministrador()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      if($this->getObjetoBean()->getfechaInicioBalance()) : $a_Fields['fechaInicioBalance'] = ($this->getObjetoBean()->getfechaInicioBalance()); endif;
      if($this->getObjetoBean()->getFechaSaldoIni()) : $a_Fields['FechaSaldoIni'] = ($this->getObjetoBean()->getFechaSaldoIni()); endif;
      if($this->getObjetoBean()->getSaldoDisponibleIni()) : $a_Fields['SaldoDisponibleIni'] = ($this->getObjetoBean()->getSaldoDisponibleIni()); endif;
      $a_Fields['flagCC'] = '-1';
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_sucursal SET
                  ".$sString."
            WHERE 1 AND IdSucursal= '".$this->getObjetoBean()->getIdSucursal()."' ";
      
      $result = $con->query($sql);

       //echo $sql;
      $iResultSave = $con->query($sql);
           
      
      //echo $sql;           
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    
      $o_Sucursal = new SucursalBean();
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdSucursal()){
          $o_Sucursal->setIdSucursal($this->getObjetoBean()->getIdSucursal());
      }
            
      $sql = "UPDATE cr_sucursal 
              SET
                Eliminado = '1',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdSucursal= '".$this->getObjetoBean()->getIdSucursal()."' ";
      
      $result = $con->query($sql);
      
      $num_rows = $result->rowCount();
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  
  public function select(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    if(trim($orden) =='') $orden = "ORDER BY IdSucursal DESC";
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_sucursal
            WHERE  Eliminado <> '1' ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    //echo $sql;
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  /**
  * Retorna un objeto SucursalBean
  *
  * @return Object
  */
  

  
   public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_sucursal WHERE 1 and IdSucursal='".$this->getObjetoBean()->getIdSucursal()."'";
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    
    //echo $sql;
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  
  /**
  * Reasigna valores retornados del propel a un objeto SucursalBean
  *
  * @param Object $o_Propel
  * @return SucursalBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_SucursalBean = new SucursalBean();
    
    $o_SucursalBean->setIdSucursal($o_Propel->IdSucursal);
    $o_SucursalBean->setDescripcion($o_Propel->Descripcion);
    $o_SucursalBean->setDireccion($o_Propel->Direccion);
    $o_SucursalBean->setTelefono($o_Propel->Telefono);
    $o_SucursalBean->setFechaSaldoIni($o_Propel->FechaSaldoIni);
    $o_SucursalBean->setEliminado($o_Propel->Eliminado);
    $o_SucursalBean->setEstado($o_Propel->Estado);
    $o_SucursalBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_SucursalBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_SucursalBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_SucursalBean->setFechaModificacion($o_Propel->FechaModificacion);
    $o_SucursalBean->setIdAdministrador($o_Propel->IdAdministrador);
    $o_SucursalBean->setFechaEliminado($o_Propel->FechaEliminado);
    $o_SucursalBean->setUsuarioEliminado($o_Propel->UsuarioEliminado);
    $o_SucursalBean->setfechaInicioBalance($o_Propel->fechaInicioBalance);
    $o_SucursalBean->setSaldoDisponibleIni($o_Propel->SaldoDisponibleIni);
    
   
    return $o_SucursalBean;    
    
  }
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    
    $sql = "SELECT * FROM cr_sucursal WHERE Eliminado <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    
    //echo $sql;
    return $num_rows;
    
}
private function buildConsult(){
    
    $where = "";
    
    if($this->getObjetoBean()->getIdSucursal()){
       $where .= " AND IdSucursal  = '".$this->getObjetoBean()->getIdSucursal()."'";
    }
    if($this->getObjetoBean()->getIdsSucursales()){
       $where .= " AND IdSucursal in ('".implode("','",$this->getObjetoBean()->getIdsSucursales())."')";
    }
	
    if($this->getObjetoBean()->getDescripcion()){
       $where .= " AND Descripcion like '%".$this->getObjetoBean()->getDescripcion()."%'";
    }
    if($this->getObjetoBean()->getEstado()){
        $where .= " AND Estado  = '".$this->getObjetoBean()->getEstado()."'";
    }
    if($this->getObjetoBean()->getIdAdministrador()){
        $where .= " AND IdAdministrador  = '".$this->getObjetoBean()->getIdAdministrador()."'";
    }
    return $where;
    
  }
  
   public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }

}
