<?php
/**
 * Clase SucursalBL
 *
 * @package    
 * @subpackage 
 * @author     SucursalBL
 * @version    SVN: $Id: SucursalBL.class.php,v 1.1 2008/02/08 21:56:44 william.taype Exp $ 
 */
class SucursalBL{
    
  /**
  * 
  *
  * @param $o_SucursalBean, objeto de tipo Sucursal 
  * @return Boolean
  */
   public function getSucursal(SucursalBean $o_SucursalBean){
    
    $o_SucursalCT = new SucursalCT();
    return $o_SucursalCT->seleccionar($o_SucursalBean);
    
  }
  
  public function busquedaSucursal(SucursalBean $o_SucursalBean){
    
    $o_SucursalDP = new SucursalDP($o_SucursalBean);
    if($o_SucursalBean->getIdSucursal()){
      $a_Sucursal = $o_SucursalDP->selectByPk();
    }else{
      $a_Sucursal = $o_SucursalDP->select();
    }
    
    if(is_array($a_Sucursal)){
    	foreach ($a_Sucursal as $key => $o_Sucursal){
		    //Administrador en el Gri unido la Tabla Sucursal con Colaborador 
		    $o_ColaboradorBean = new ColaboradorBean();
		    $o_ColaboradorBean->setIdColaborador($o_Sucursal->getIdAdministrador());
		    $o_ColaboradorBL = new ColaboradorBL();
			$a_Colaborador = $o_ColaboradorBL->busquedaColaborador($o_ColaboradorBean);
		    $o_Sucursal->setObjectColaborador($a_Colaborador[0]);
		    $a_temp[] = $o_Sucursal;
    	}
    }elseif (is_object($a_Sucursal)){
    	 //Administrador en el Gri unido la Tabla Sucursal con Colaborador 
	    $o_ColaboradorBean = new ColaboradorBean();
	    $o_ColaboradorBean->setIdColaborador($a_Sucursal->getIdAdministrador());
	    $o_ColaboradorBL = new ColaboradorBL();
		$a_Colaborador = $o_ColaboradorBL->busquedaColaborador($o_ColaboradorBean);
	    $a_Sucursal->setObjectColaborador($a_Colaborador[0]);
	    $a_temp[] = $a_Sucursal;
    }
    return $a_temp;
  }
  
  public function busquedaSucursalResulset(SucursalBean $o_SucursalBean){
    
    $o_SucursalDP = new SucursalDP($o_SucursalBean);
    return $o_SucursalDP->selectResultset();
        
  }
  
  /***************************************/
  
  public function insertarSucursal(SucursalBean $o_SucursalBean){
    $o_SucursalCT = new SucursalCT();
    
    $bResult = $o_SucursalCT->guardar($o_SucursalBean);
    
    if($bResult){
      
      $a_tmp = $o_SucursalBean->getArraySucMercado();
      if(is_array($a_tmp)){
        foreach ($a_tmp as $o_SucMercadoBean){
          
          $o_SucMercadoBean->setIdSucursal($o_SucursalBean->getIdSucursal());
          
          $o_SucMercadoBL = new SucursalMercadoBL();
          $bResult2 = $o_SucMercadoBL->insertarSucursalMercado($o_SucMercadoBean);
          
        }
      }
      
      return true;
      
    }else{
      
      $o_SucursalBean->setError(1);
      $o_SucursalBean->setMensaje("No se pudo insertar la cabecera Sucursal");
      return false;
      
    }
    
    $o_SucursalCT->guardar($o_SucursalBean);
  }
  
  
  
  /***************************************/
  
  /*public function insertarSucursal(SucursalBean $o_SucursalBean){
    
    $o_SucursalCT = new SucursalCT();
    return $o_SucursalCT->guardar($o_SucursalBean);
    
  }*/
  /*public function modificarSucursal(SucursalBean $o_SucursalBean){
      $o_SucursalCT = new SucursalCT();
      return $o_SucursalCT->modificar($o_SucursalBean);
  }*/
  /**
	* Funcin que retorna un objeto Sucursal o una lista de Objetos de Sucursal,
	* dependiendo del parametro que se le envia si este contiene o no el Id de Sucursal
	*
	* @param $o_SucursalBean, es un objeto de tipo Sucursal
	* @return Object
	*/
	public function modificarEstadoSucursal(SucursalBean $o_SucursalBean){
	  
	}
  
  public function eliminarSucursal(SucursalBean $o_SucursalBean){
    $o_SucursalCT = new SucursalCT();
    return $o_SucursalCT->eliminar($o_SucursalBean);
    
  }
  
  public function getCountResult(SucursalBean $o_SucursalBean){
    $o_SucursalCT = new SucursalCT();
    return $o_SucursalCT->totalRegistros($o_SucursalBean);
  }
  
  public function busquedaSucursalDetalles(SucursalBean $o_SucursalBean){
        
    $o_Sucursal = $this->busquedaSucursal($o_SucursalBean);
    
    $o_SucursalMercadoBean = new SucursalMercadoBean();
    $o_SucursalMercadoBean->setIdSucursal($o_Sucursal[0]->getIdSucursal());
    
    $o_SucursalMercadoBL = new SucursalMercadoBL();
    $a_tmpSucursalMercado = $o_SucursalMercadoBL->busquedaSucursalMercadoDetalle($o_SucursalMercadoBean);
    
    
		    
    $o_Sucursal[0]->setArraySucMercado($a_tmpSucursalMercado);
    
    return $o_Sucursal[0];
  
  }
  
  public function modificarSucursal(SucursalBean $o_SucursalBean){
    $o_SucursalCT = new SucursalCT();
    
    $bResult = $o_SucursalCT->modificar($o_SucursalBean);
    
    if($bResult){
      //Objeto temporal
      $tmp_ObjectSucursal = $this->getSucursal($o_SucursalBean);
      $o_SucursalBean->setIdSucursal($o_SucursalBean->getIdSucursal());
      
      //COLABORADOR      
      if(is_array($o_SucursalBean->getArraySucMercadoAct())){
        
        //estoy entregando del formulario
        $a_tmp = $o_SucursalBean->getArraySucMercadoAct();
        
        $o_SucursalMercadoBean = new SucursalMercadoBean();
        $o_SucursalMercadoBean->setIdSucursal($o_SucursalBean->getIdSucursal());
        
        $o_SucursalMercadoBL = new SucursalMercadoBL();
        //tengo en la base de datos
        $a_tmpSucursalMercado = $o_SucursalMercadoBL->busquedaSucursalMercadoDetalle($o_SucursalMercadoBean);
        
        foreach ($a_tmpSucursalMercado as $ikey => $o_SucursalMercadoBean){
            $bFound = false;
            foreach ($a_tmp as $ikeyUpd => $o_SucursalMercadoUpdateBean){
              
              if($o_SucursalMercadoBean->getIdMercado() == $o_SucursalMercadoUpdateBean->getIdMercado()){
                $o_SucursalMercadoBL = new SucursalMercadoBL();
                $bResult = $o_SucursalMercadoBL->modificarEstadoSucursalMercado($o_SucursalMercadoUpdateBean);
                $bFound = true;
                break;
              }
              
            }
            
            if(!$bFound){
              $o_SucursalMercadoBL = new SucursalMercadoBL();
              $bResult = $o_SucursalMercadoBL->eliminarSucursalMercado($o_SucursalMercadoBean);
            }
            
        }
      
     }else{
        
        $bResultEliminarSMercado = $this->EliminarSMercadoPorIdSucursal($o_SucursalBean);
        
     }
      
      if(is_array($o_SucursalBean->getArraySucMercado())){
        
        $a_tmp = $o_SucursalBean->getArraySucMercado();
        
        foreach ($a_tmp as $o_SucursalMercadoBean){
          $o_SucursalMercadoBean->setIdSucursal($o_SucursalMercadoBean->getIdSucursal());
          
          $o_SucursalMercadoBL = new SucursalMercadoBL();
          $bResult2 = $o_SucursalMercadoBL->insertarSucursalMercado($o_SucursalMercadoBean);
          
        }
        
      }
   }
    return true;
    
  }
    public function EliminarSMercadoPorIdSucursal(SucursalBean $o_SucursalBean){
    
    $o_SucursalMercadoBean = new SucursalMercadoBean();
    $o_SucursalMercadoBean->setIdSucursal($o_SucursalBean->getIdSucursal());
    $o_SucursalMercadoBL = new SucursalMercadoBL();
    return $o_SucursalMercadoBL->eliminarSucursalMercado($o_SucursalMercadoBean);
    
  } 
  
}?>