<?php

/**
* Clase Dispacher para Colaborador
*
* @package IM
* @subpackage ColaboradorDP
* @author Willy
* @version SVN: : ColaboradorDP.class.php,v 1.1 2009/05/18 21:33:02 Exp $
*/
class ColaboradorDP implements interfaceDP {
	
   private static $fieldNames = array (
    'Colaborador' => 'IdColaborador', 'Nombre' => 'Nombres', 'Apellido' => 'ApellidoPaterno', 'IdRol' => 'IdRol'
	);
			
  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto ColaboradorBean
  *
  * @param ColaboradorBean $o_ColaboradorBean
  */
  public function __construct(ColaboradorBean $o_ColaboradorBean){
  
    $this->o_Bean = $o_ColaboradorBean;
    
  }
  
  /**
  * Retorna el objeto ColaboradorBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new ColaboradorBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      //if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getIdTipoColaborador()) : $a_Fields['IdTipoColaborador'] = ($this->getObjetoBean()->getIdTipoColaborador()); endif;
      if($this->getObjetoBean()->getIdPadre()) : $a_Fields['IdPadre'] = ($this->getObjetoBean()->getIdPadre()); endif;
      if($this->getObjetoBean()->getMontoDescuento()) : $a_Fields['MontoDescuento'] = ($this->getObjetoBean()->getMontoDescuento()); endif;
      if($this->getObjetoBean()->getGradoInstruccion()) : $a_Fields['GradoInstruccion'] = ($this->getObjetoBean()->getGradoInstruccion()); endif;
      if($this->getObjetoBean()->getDni()) : $a_Fields['dni'] = ($this->getObjetoBean()->getDni()); endif;
      if($this->getObjetoBean()->getNombres()) : $a_Fields['Nombres'] = ($this->getObjetoBean()->getNombres()); endif;
      if($this->getObjetoBean()->getApellidoPaterno()) : $a_Fields['ApellidoPaterno'] = ($this->getObjetoBean()->getApellidoPaterno()); endif;
      if($this->getObjetoBean()->getApellidoMaterno()) : $a_Fields['ApellidoMaterno'] = ($this->getObjetoBean()->getApellidoMaterno()); endif;
      if($this->getObjetoBean()->getDireccion()) : $a_Fields['Direccion'] = ($this->getObjetoBean()->getDireccion()); endif;
      if($this->getObjetoBean()->getEmail()) : $a_Fields['Email'] = ($this->getObjetoBean()->getEmail()); endif;
      if($this->getObjetoBean()->getTelefono()) : $a_Fields['Telefono'] = ($this->getObjetoBean()->getTelefono()); endif;
      if($this->getObjetoBean()->getCelular()) : $a_Fields['Celular'] = ($this->getObjetoBean()->getCelular()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getIdRol()) : $a_Fields['IdRol'] = ($this->getObjetoBean()->getIdRol()); endif;
      if($this->getObjetoBean()->getUsuario()) : $a_Fields['Usuario'] = ($this->getObjetoBean()->getUsuario()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getFechaNacimiento()) : $a_Fields['FechaNacimiento'] = ($this->getObjetoBean()->getFechaNacimiento()); endif;
      if($this->getObjetoBean()->getSueldo()) : $a_Fields['Sueldo'] = ($this->getObjetoBean()->getSueldo()); endif;
      if($this->getObjetoBean()->getSueldoMovilidad()) : $a_Fields['SueldoMovilidad'] = ($this->getObjetoBean()->getSueldoMovilidad()); endif;
      if($this->getObjetoBean()->getSexo()) : $a_Fields['Sexo'] = ($this->getObjetoBean()->getSexo()); endif;
      if($this->getObjetoBean()->getEstadoCivil()) : $a_Fields['EstadoCivil'] = ($this->getObjetoBean()->getEstadoCivil()); endif;
      if($this->getObjetoBean()->getGradoInstruccion()) : $a_Fields['GradoInstruccion'] = ($this->getObjetoBean()->getGradoInstruccion()); endif;
      if($this->getObjetoBean()->getNumeroHijos()) : $a_Fields['NumeroHijos'] = ($this->getObjetoBean()->getNumeroHijos()); endif;
      if($this->getObjetoBean()->getFechaIngreso()) : $a_Fields['FechaIngreso'] = ($this->getObjetoBean()->getFechaIngreso()); endif;
      
      
      /*-----------------Planilla---------------------*/
      if($this->getObjetoBean()->getNumeroSeguro()) : $a_Fields['NumeroSeguro'] = ($this->getObjetoBean()->getNumeroSeguro()); endif;
      if($this->getObjetoBean()->getTipoSeguro()) : $a_Fields['TipoSeguro'] = ($this->getObjetoBean()->getTipoSeguro()); endif;
      if($this->getObjetoBean()->getPension()) : $a_Fields['Pension'] = ($this->getObjetoBean()->getPension()); endif;
      if($this->getObjetoBean()->getNombrePension()) : $a_Fields['NombrePension'] = ($this->getObjetoBean()->getNombrePension()); endif;
      if($this->getObjetoBean()->getNumeroPension()) : $a_Fields['NumeroPension'] = ($this->getObjetoBean()->getNumeroPension()); endif;
      if($this->getObjetoBean()->getTipoPension()) : $a_Fields['TipoPension'] = ($this->getObjetoBean()->getTipoPension()); endif;
      
      if($this->getObjetoBean()->getBono()) : $a_Fields['Bono'] = ($this->getObjetoBean()->getBono()); endif;
      if($this->getObjetoBean()->getAsignacionFamiliar()) : $a_Fields['AsignacionFamiliar'] = ($this->getObjetoBean()->getAsignacionFamiliar()); endif;
      if($this->getObjetoBean()->getPagoRpm()) : $a_Fields['PagoRpm'] = ($this->getObjetoBean()->getPagoRpm()); endif;
      
      if($this->getObjetoBean()->getTipoPlanilla()) : $a_Fields['TipoPlanilla'] = ($this->getObjetoBean()->getTipoPlanilla()); endif;
      if($this->getObjetoBean()->getHoraIngreso()) : $a_Fields['HoraIngreso'] = ($this->getObjetoBean()->getHoraIngreso()); endif;
      if($this->getObjetoBean()->getMinutoIngreso()) : $a_Fields['MinutoIngreso'] = ($this->getObjetoBean()->getMinutoIngreso()); endif;
      
	 /*-----------------Fin Planilla---------------------*/    
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO cr_colaborador (".$sStringField.")
                      VALUES (".$sStringValue.");";
       //echo $sql;
	   $con->query("SET NAMES 'utf8'");
      $iResultSave = $con->query($sql);
      //
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  
   public function update() {

    if($this->getObjetoBean()->getIdColaborador()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getIdPadre()) : $a_Fields['IdPadre'] = ($this->getObjetoBean()->getIdPadre()); endif;
      
      if($this->getObjetoBean()->getGradoInstruccion()) : $a_Fields['GradoInstruccion'] = ($this->getObjetoBean()->getGradoInstruccion()); endif;
      if($this->getObjetoBean()->getDni()) : $a_Fields['dni'] = ($this->getObjetoBean()->getDni()); endif;
      if($this->getObjetoBean()->getNombres()) : $a_Fields['Nombres'] = ($this->getObjetoBean()->getNombres()); endif;
      if($this->getObjetoBean()->getMontoDescuento()) : $a_Fields['MontoDescuento'] = ($this->getObjetoBean()->getMontoDescuento()); endif;
      if($this->getObjetoBean()->getApellidoPaterno()) : $a_Fields['ApellidoPaterno'] = ($this->getObjetoBean()->getApellidoPaterno()); endif;
      if($this->getObjetoBean()->getApellidoMaterno()) : $a_Fields['ApellidoMaterno'] = ($this->getObjetoBean()->getApellidoMaterno()); endif;
      if($this->getObjetoBean()->getDireccion()) : $a_Fields['Direccion'] = ($this->getObjetoBean()->getDireccion()); endif;
      if($this->getObjetoBean()->getEmail()) : $a_Fields['Email'] = ($this->getObjetoBean()->getEmail()); endif;
      if($this->getObjetoBean()->getTelefono()) : $a_Fields['Telefono'] = ($this->getObjetoBean()->getTelefono()); endif;
      if($this->getObjetoBean()->getCelular()) : $a_Fields['Celular'] = ($this->getObjetoBean()->getCelular()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getIdRol()) : $a_Fields['IdRol'] = ($this->getObjetoBean()->getIdRol()); endif;
      if($this->getObjetoBean()->getUsuario()) : $a_Fields['Usuario'] = ($this->getObjetoBean()->getUsuario()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getFechaNacimiento()) : $a_Fields['FechaNacimiento'] = ($this->getObjetoBean()->getFechaNacimiento()); endif;
      if($this->getObjetoBean()->getSueldo()) : $a_Fields['Sueldo'] = ($this->getObjetoBean()->getSueldo()); endif;
	  if($this->getObjetoBean()->getSueldoMovilidad()) : $a_Fields['SueldoMovilidad'] = ($this->getObjetoBean()->getSueldoMovilidad()); endif;
      if($this->getObjetoBean()->getSexo()) : $a_Fields['Sexo'] = ($this->getObjetoBean()->getSexo()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;      
      if($this->getObjetoBean()->getEstadoCivil()) : $a_Fields['EstadoCivil'] = ($this->getObjetoBean()->getEstadoCivil()); endif;
      if($this->getObjetoBean()->getGradoInstruccion()) : $a_Fields['GradoInstruccion'] = ($this->getObjetoBean()->getGradoInstruccion()); endif;
      if($this->getObjetoBean()->getNumeroHijos()) : $a_Fields['NumeroHijos'] = ($this->getObjetoBean()->getNumeroHijos()); endif;
      if($this->getObjetoBean()->getFechaIngreso()) : $a_Fields['FechaIngreso'] = ($this->getObjetoBean()->getFechaIngreso()); endif;
      
      
      /*-----------------Planilla---------------------*/
      if($this->getObjetoBean()->getNumeroSeguro()) : $a_Fields['NumeroSeguro'] = ($this->getObjetoBean()->getNumeroSeguro()); endif;
      if($this->getObjetoBean()->getTipoSeguro()) : $a_Fields['TipoSeguro'] = ($this->getObjetoBean()->getTipoSeguro()); endif;
      if($this->getObjetoBean()->getPension()) : $a_Fields['Pension'] = ($this->getObjetoBean()->getPension()); endif;
      if($this->getObjetoBean()->getNombrePension()) : $a_Fields['NombrePension'] = ($this->getObjetoBean()->getNombrePension()); endif;
      if($this->getObjetoBean()->getNumeroPension()) : $a_Fields['NumeroPension'] = ($this->getObjetoBean()->getNumeroPension()); endif;
      if($this->getObjetoBean()->getTipoPension()) : $a_Fields['TipoPension'] = ($this->getObjetoBean()->getTipoPension()); endif;
      
      if($this->getObjetoBean()->getBono()) : $a_Fields['Bono'] = ($this->getObjetoBean()->getBono()); endif;
      if($this->getObjetoBean()->getAsignacionFamiliar()) : $a_Fields['AsignacionFamiliar'] = ($this->getObjetoBean()->getAsignacionFamiliar()); endif;
      if($this->getObjetoBean()->getPagoRpm()) : $a_Fields['PagoRpm'] = ($this->getObjetoBean()->getPagoRpm()); endif;
      if($this->getObjetoBean()->getComisionPorcentajeMora()) : $a_Fields['ComisionPorcentajeMora'] = ($this->getObjetoBean()->getComisionPorcentajeMora()); endif;
      if($this->getObjetoBean()->getTipoPlanilla()) : $a_Fields['TipoPlanilla'] = ($this->getObjetoBean()->getTipoPlanilla()); endif;
      if($this->getObjetoBean()->getHoraIngreso()) : $a_Fields['HoraIngreso'] = ($this->getObjetoBean()->getHoraIngreso()); endif;
      if($this->getObjetoBean()->getMinutoIngreso()) : $a_Fields['MinutoIngreso'] = ($this->getObjetoBean()->getMinutoIngreso()); endif;
      
      if($this->getObjetoBean()->getFlagPermitirPago()) : $a_Fields['FlagPermitirPago'] = ($this->getObjetoBean()->getFlagPermitirPago()); endif;
      
	 /*-----------------Fin Planilla---------------------*/      
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_colaborador SET
                  ".$sString."
            WHERE 1 AND IdColaborador= '".$this->getObjetoBean()->getIdColaborador()."' ";
      $con->query("SET NAMES 'utf8'");
      $result = $con->query($sql);
      //
      //echo $sql;            
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  
 
  public function delete(){
    
      $o_Colaborador = new ColaboradorBean();
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdColaborador()){
          $o_Colaborador->setIdColaborador($this->getObjetoBean()->getIdColaborador());
      }
            
      $sql = "UPDATE cr_colaborador 
              SET
                Eliminado = '1',
                Estado ='I',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."' ";
      
      $result = $con->query($sql);
      
      $num_rows = $result->rowCount();
      //
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  
  
  
 
public function select(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    if(trim($orden) =='') $orden = "ORDER BY IdColaborador DESC";
    $con = Conexion::getConexion();
    $sql = "SELECT * 
            FROM cr_colaborador 
            WHERE   Eliminado <> '1' ".
    		$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
  	//echo $sql;
    $con->query("SET NAMES 'utf8'");
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    //
   
    return count($a_tmp)>0?$a_tmp:null;
      
  } 
  
  
  
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */

  
  /**
  * Retorna un objeto ColaboradorBean
  *
  * @return Object
  */
  
   
  
 public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * 
            FROM cr_colaborador 
            WHERE  IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."' ";
    $con->query("SET NAMES 'utf8'");
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
   //  
   
    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }
       
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto ColaboradorBean
  *
  * @param Object $o_Propel
  * @return ColaboradorBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_ColaboradorBean = new ColaboradorBean();
    
    $o_ColaboradorBean->setIdColaborador($o_Propel->IdColaborador);
    $o_ColaboradorBean->setIdPadre($o_Propel->IdPadre);
    $o_ColaboradorBean->setIdTipoColaborador($o_Propel->IdTipoColaborador);
    $o_ColaboradorBean->setGradoInstruccion($o_Propel->GradoInstruccion);
    $o_ColaboradorBean->setDni($o_Propel->dni);
    $o_ColaboradorBean->setNombres($o_Propel->Nombres);
    $o_ColaboradorBean->setApellidoPaterno($o_Propel->ApellidoPaterno);
    $o_ColaboradorBean->setApellidoMaterno($o_Propel->ApellidoMaterno);
    $o_ColaboradorBean->setDireccion($o_Propel->Direccion);
    $o_ColaboradorBean->setEmail($o_Propel->Email);
    $o_ColaboradorBean->setTelefono($o_Propel->Telefono);
    $o_ColaboradorBean->setCelular($o_Propel->Celular);
    $o_ColaboradorBean->setEstado($o_Propel->Estado);
    $o_ColaboradorBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_ColaboradorBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_ColaboradorBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_ColaboradorBean->setFechaModificacion($o_Propel->FechaModificacion);
    $o_ColaboradorBean->setFechaNacimiento($o_Propel->FechaNacimiento);
    $o_ColaboradorBean->setGradoInstruccion($o_Propel->GradoInstruccion);
    $o_ColaboradorBean->setNumeroHijos($o_Propel->NumeroHijos);
    $o_ColaboradorBean->setSueldo($o_Propel->Sueldo);
    $o_ColaboradorBean->setSueldoMovilidad($o_Propel->SueldoMovilidad);
    $o_ColaboradorBean->setSexo($o_Propel->Sexo);
    $o_ColaboradorBean->setEstadoCivil($o_Propel->EstadoCivil);
    $o_ColaboradorBean->setIdRol($o_Propel->IdRol);
    $o_ColaboradorBean->setUsuario($o_Propel->Usuario);
    $o_ColaboradorBean->setFechaIngreso($o_Propel->FechaIngreso);
    
    $o_ColaboradorBean->setPagoRpm($o_Propel->PagoRpm);
    $o_ColaboradorBean->setMontoDescuento($o_Propel->MontoDescuento);
    $o_ColaboradorBean->setComisionPorcentajeMora($o_Propel->ComisionPorcentajeMora);
    
	$o_ColaboradorBean->setTipoSeguro($o_Propel->TipoSeguro); 
	$o_ColaboradorBean->setTipoPension($o_Propel->TipoPension); 
	$o_ColaboradorBean->setPension($o_Propel->Pension); 
	$o_ColaboradorBean->setNumeroPension($o_Propel->NumeroPension); 
	$o_ColaboradorBean->setNumeroSeguro($o_Propel->NumeroSeguro); 
	$o_ColaboradorBean->setBono($o_Propel->Bono); 
	$o_ColaboradorBean->setAsignacionFamiliar($o_Propel->AsignacionFamiliar); 
	$o_ColaboradorBean->setTipoPlanilla($o_Propel->TipoPlanilla); 
	$o_ColaboradorBean->setHoraIngreso($o_Propel->HoraIngreso); 
	$o_ColaboradorBean->setMinutoIngreso($o_Propel->MinutoIngreso); 
    
    $o_ColaboradorBean->setFlagPermitirPago($o_Propel->FlagPermitirPago);            

    return $o_ColaboradorBean;    
    
  }

  public function CambioAdministrador(){
  	//Cuando hay cambio de administrador 
  	//Todos los hijos del Administrador Anterior pasan 
  	//a ser hijos del nuevo Administrador
  	 
    $con = Conexion::getConexion();
    
    $sql = "UPDATE 
			cr_colaborador
			SET IdPadre = '".$this->getObjetoBean()->getIdPadre()."'
            WHERE  IdPadre = '".$this->getObjetoBean()->getIdPadreAnterior()."'";
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
  
    //
   
    return $num_rows;
  	
  }
  
  public function selectNumRows(){
    
   $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    
    $sql = "SELECT * 
            FROM cr_colaborador
            WHERE  Eliminado <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    //echo $sql;
    //
   
    return $num_rows;
    
  }
    

  private function buildConsult(){
    
    $where = "";
    
  	if(is_array($this->getObjetoBean()->getIdColaboradores())){
      	 $where .= " AND IdColaborador in ('".implode("','",$this->getObjetoBean()->getIdColaboradores())."')";
    }
    if($this->getObjetoBean()->getIdColaborador()){
       $where .= " AND IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
    }
       
    if($this->getObjetoBean()->getIdRol()){
       $where .= " AND IdRol = '".$this->getObjetoBean()->getIdRol()."'";
    }
    if($this->getObjetoBean()->getEstado()){
       $where .= " AND Estado = '".$this->getObjetoBean()->getEstado()."'";
    }
     if($this->getObjetoBean()->getEliminado()){
       $where .= " AND eliminado = '".(int)$this->getObjetoBean()->getEliminado()."'";
    }
    
    if($this->getObjetoBean()->getApellidoPaterno()){
       $where .= " AND ApellidoPaterno like '".$this->getObjetoBean()->getApellidoPaterno()."%'";
    }
    
	if($this->getObjetoBean()->getTipoPlanilla()){
       $where .= " AND TipoPlanilla = '".$this->getObjetoBean()->getTipoPlanilla()."'";
    }
	
    if($this->getObjetoBean()->getApellidoMaterno()){
       $where .= " AND ApellidoMaterno like '".$this->getObjetoBean()->getApellidoMaterno()."%'";
    }
    
    if($this->getObjetoBean()->getNombres()){
       $where .= " AND Nombres like '%".$this->getObjetoBean()->getNombres()."%'";
    }
   
	if($this->getObjetoBean()->getDni()){
       $where .= " AND dni like '".$this->getObjetoBean()->getDni()."%'";
    }
    
    if($this->getObjetoBean()->getIdPadre()){
       $where .= " AND IdPadre = '".$this->getObjetoBean()->getIdPadre()."'";
    }
    
    if($this->getObjetoBean()->getUsuario()){
       $where .= " AND Usuario = '".$this->getObjetoBean()->getUsuario()."'";
    }
    
    if(is_array($this->getObjetoBean()->getFiltroColaborador())){
      	 $where .= " AND IdRol in ('".implode("','",$this->getObjetoBean()->getFiltroColaborador())."')";
    }
      
    return $where;
    
  }

  public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
  
  //Para WS-------------------------------------------------------------------
  public function getFechaTransaccion($idColaborador){
  	
  		$o_crColaboradorBean 	= new ColaboradorBean();
		$o_crColaboradorBean->setIdColaborador($idColaborador);
		
		$o_crColaboradorDP 		= new ColaboradorDP($o_crColaboradorBean);
		$a_o_crColaboradorDP 	= $o_crColaboradorDP->select();
				
		if(is_array($a_o_crColaboradorDP) && count($a_o_crColaboradorDP)){
  			$o_BalanceDia 		= new BalanceDiaBean();
			$o_crColaboradorDP 	= $a_o_crColaboradorDP[0];
			
			if($o_crColaboradorDP->getUsuario() == "sys.res") $IdAdministrador 	= $idColaborador;
			else $IdAdministrador 	= $o_crColaboradorDP->getIdPadre();
	  		$o_SucursalBean 	= new SucursalBean();
			$o_SucursalBean->setIdAdministrador($IdAdministrador);
			$o_SucursalBL 		= new SucursalBL();
			$a_o_sucursal 		= $o_SucursalBL->busquedaSucursal($o_SucursalBean);
			
			if(is_array($a_o_sucursal)){
				$IdSucursal = $a_o_sucursal[0]->getIdSucursal();
				$o_BalanceDia->setIdSucursal($IdSucursal);
				$o_BalanceDiaDP = new BalanceDiaDP($o_BalanceDia);
				$fecha 			= $o_BalanceDiaDP->ObtenerDiaAbierto();
				return  $fecha;
			}else{
				return false;
			}	
		}else{
			return false;
		}
  }
  
}?>