
<?php

/**
* Clase Dispacher para PartesPrestamo
*
* @package IM
* @subpackage PartesPrestamoDP
* @author Willy
* @version SVN: : PartesPrestamoDP.class.php,v 1.1 2009/06/10 22:59:27 Exp $
*/
class PartesPrestamoDP implements interfaceDP {

  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto PartesPrestamoBean
  *
  * @param PartesPrestamoBean $o_PartesPrestamoBean
  */
  public function __construct(PartesPrestamoBean $o_PartesPrestamoBean){
  
    $this->o_Bean = $o_PartesPrestamoBean;
    
  }
  
  /**
  * Retorna el objeto PartesPrestamoBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new PartesPrestamoBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){

    $con = Conexion::getConexion();
    
      $a_Fields = array();
    
      if($this->getObjetoBean()->getIdPrestamo()) : $a_Fields['IdPrestamo'] = ($this->getObjetoBean()->getIdPrestamo()); endif;
      if($this->getObjetoBean()->getFecha()) : $a_Fields['Fecha'] = ($this->getObjetoBean()->getFecha()); endif;
      if($this->getObjetoBean()->getMonto()) : $a_Fields['Monto'] = ($this->getObjetoBean()->getMonto()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
	  $a_Fields['Eliminado'] = '0';
	  
	  if($this->getObjetoBean()->getRegistroLatitud()) 	: $a_Fields['registrolatitud'] = ($this->getObjetoBean()->getRegistroLatitud()); endif;
	  if($this->getObjetoBean()->getRegistroLongitud()) : $a_Fields['registrolongitud'] = ($this->getObjetoBean()->getRegistroLongitud()); endif;
	  
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
       
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      //$con = Conexion::getConexion();
      $sql = "INSERT INTO cr_partesprestamo (".$sStringField.")
                      VALUES (".$sStringValue.");";
      $result = $con->query($sql);
      

      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    
  }
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
 
  
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getIdPartePrestamo()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getIdPartePrestamo()) : $a_Fields['IdPartePrestamo'] = ($this->getObjetoBean()->getIdPartePrestamo()); endif;
      if($this->getObjetoBean()->getIdPrestamo()) : $a_Fields['IdPrestamo'] = ($this->getObjetoBean()->getIdPrestamo()); endif;
      if($this->getObjetoBean()->getMonto()) : $a_Fields['Monto'] = ($this->getObjetoBean()->getMonto()); endif;
	  if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
	  if($this->getObjetoBean()->getFecha()) : $a_Fields['Fecha'] = ($this->getObjetoBean()->getFecha()); endif;
      $a_Fields['Eliminado'] = '0';
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['cr_partesprestamo.FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['cr_partesprestamo.UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['cr_partesprestamo.UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['cr_partesprestamo.FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['cr_partesprestamo.FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['cr_partesprestamo.UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
	  if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
       
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_partesprestamo SET
                  ".$sString."
            WHERE 1 AND IdPartesPrestamo= '".$this->getObjetoBean()->getIdPartesPrestamo()."' ";
      
      $result = $con->query($sql);
      
                  
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
  	           
      $con = Conexion::getConexion();
      
      /*if($this->getObjetoBean()->getIdPartesPrestamo()){
          $o_Cliente->setIdPartesPrestamo($this->getObjetoBean()->getIdPartesPrestamo());
      }*/
            
      $sql = "UPDATE cr_partesprestamo 
              SET
                Eliminado = '1',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdPartesPrestamo= '".$this->getObjetoBean()->getIdPartesPrestamo()."' ";
      
      $result = $con->query($sql);
      
      $num_rows = $result->rowCount();
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  	
  	
    /*
      $o_PartesPrestamo = new PartesPrestamo();
      
      if($this->getObjetoBean()->getIdPartesPrestamo()){
          $o_PartesPrestamo->setIdPartesPrestamo($this->getObjetoBean()->getIdPartesPrestamo());
      }
      $iResultDelete = $o_PartesPrestamo->delete();
      if($iResultDelete > 0){
          return true;
      }else{
          return false;
      }    
    */
  
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
public function select(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    if(trim($orden) =='') $orden = "ORDER BY IdPartePrestamo DESC";
    $con = Conexion::getConexion();
    $sql = "SELECT cr_partesprestamo.*
			   	FROM cr_partesprestamo
					LEFT JOIN cr_prestamo ON cr_prestamo.IdPrestamo = cr_partesprestamo.IdPrestamo
					LEFT JOIN cr_cliente  ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado  ON cr_cliente.IdMercado = cr_mercado.IdMercado
					
            WHERE cr_partesprestamo.Eliminado <> '1' ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }  
 /*  public function selectTotalMonto(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = "SELECT sum(SaldoPartesPrestamo) as MONTO
			FROM cr_PartesPrestamo
				LEFT JOIN cr_cliente ON cr_cliente.IdPartePartesPrestamo = cr_PartesPrestamo.IdPartePartesPrestamo
				LEFT JOIN cr_mercado ON cr_cliente.IdMercado = cr_mercado.IdMercado
     		WHERE cr_PartesPrestamo.Eliminado <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
     while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $monto_total = $o_valor->MONTO;
      }
    
    
   
    return $monto_total;
    
  }/* 
 /* public function select(){
      
    $where = "";
    
    
    
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_PartesPrestamo WHERE 1 ".$where;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }*/
  
  /**
  * Retorna un objeto PartesPrestamoBean
  *
  * @return Object
  */
  public function selectByPk(){
     $where = $this->buildConsult();
    $con = Conexion::getConexion();
    $sql = "SELECT cr_partesprestamo.*
			   	FROM cr_partesprestamo
					LEFT JOIN cr_prestamo ON cr_prestamo.IdPrestamo = cr_partesprestamo.IdPrestamo
					LEFT JOIN cr_cliente  ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado  ON cr_cliente.IdMercado = cr_mercado.IdMercado
    		WHERE cr_partesprestamo.Eliminado <> '1' and IdPartesPrestamo = '".$this->getObjetoBean()->getIdPartesPrestamo()."' $where";
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    
    //echo $sql;
    /*
    LEFT JOIN cr_mercado_representante ON cr_cliente.IdMercado = cr_mercado_representante.IdMercado
				LEFT JOIN cr_colaborador ON cr_colaborador.IdColaborador = cr_mercado_representante.IdColaborador
    */
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto PartesPrestamoBean
  *
  * @param Object $o_Propel
  * @return PartesPrestamoBean
  */

 
  private function insertarObjetoBean($o_Propel){

    $o_PartesPrestamoBean = new PartesPrestamoBean();
    
    $o_PartesPrestamoBean->setIdPartePrestamo($o_Propel->IdPartesPrestamo);
    $o_PartesPrestamoBean->setIdPrestamo($o_Propel->IdPrestamo);
    $o_PartesPrestamoBean->setFecha($o_Propel->Fecha);
    $o_PartesPrestamoBean->setMonto($o_Propel->Monto);
    $o_PartesPrestamoBean->setEstado($o_Propel->Estado);
    $o_PartesPrestamoBean->setEliminado($o_Propel->Eliminado);
    $o_PartesPrestamoBean->setFechaEliminado($o_Propel->FechaEliminado);
    $o_PartesPrestamoBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_PartesPrestamoBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_PartesPrestamoBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_PartesPrestamoBean->setFechaModificacion($o_Propel->FechaModificacion); 
    $o_PartesPrestamoBean->setUsuarioEliminado($o_Propel->UsuarioEliminado);     
    $o_PartesPrestamoBean->setIdColaborador($o_Propel->IdColaborador);     
   
         
    return $o_PartesPrestamoBean;    
    
  }
  
  /* function ObtenerMaximoPago($IdPartesPrestamo){
  	 $con = Conexion::getConexion();
  	 $sql = "	SELECT max(MontoPago) as MaximoPago
				FROM cr_pago
    			WHERE IdPartesPrestamo = '".$IdPartesPrestamo."'";
    
    $result = $con->query($sql);
    while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      return $o_valor->MaximoPago;
    }
  } */
  
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    //concat(cr_cliente.ApellidoPaterno,' ',cr_cliente.ApellidoMaterno,' ',cr_cliente.Nombres) as NombreCliente
    $sql = "SELECT cr_partesprestamo.*
			   	FROM cr_partesprestamo
					LEFT JOIN cr_prestamo ON cr_prestamo.IdPrestamo = cr_partesprestamo.IdPrestamo
					LEFT JOIN cr_cliente  ON cr_cliente.IdCliente = cr_prestamo.IdCliente
					LEFT JOIN cr_mercado  ON cr_cliente.IdMercado = cr_mercado.IdMercado
				
    	WHERE cr_partesprestamo.Eliminado <> '1'".$where;
    //echo $sql;
    /*
    LEFT JOIN cr_mercado_representante ON cr_cliente.IdMercado = cr_mercado_representante.IdMercado
				LEFT JOIN cr_colaborador ON cr_colaborador.IdColaborador = cr_mercado_representante.IdColaborador
    */
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    
   // echo $sql;
    return $num_rows;
    
  }


  private function buildConsult(){
    
    $where = "";
    
    if($this->getObjetoBean()->getIdPartePrestamo()){
       $where .= " AND IdPartePrestamo  = '".$this->getObjetoBean()->getIdPartePrestamo()."'";
    }
    if($this->getObjetoBean()->getIdPrestamo()){
       $where .= " AND cr_partesprestamo.IdPrestamo  = '".$this->getObjetoBean()->getIdPrestamo()."'";
    }
   
    if($this->getObjetoBean()->getIdColaborador()){
       $where .= " AND cr_partesprestamo.IdColaborador  = '".$this->getObjetoBean()->getIdColaborador()."'";
    }
    
    
    if($this->getObjetoBean()->getEstado()){
        $where .= " AND cr_partesprestamo.Estado  = '".$this->getObjetoBean()->getEstado()."'";
    }
    
    return $where;
    
  }
  
   public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
    
}?>