<?php
/**
 * Clase ContPrestamoer para Prestamo
 *
 * @package    IM
 * @subpackage PrestamoCT
 * @author     Willy
 * @version    SVN: $Id: PrestamoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class PrestamoCT implements interfaceCT{
  /**
  * Función para Guardar el  Prestamo
  *
  * @param $o_PrestamoBean, objeto bean de Prestamo
  * @return booleam
  */
  public function guardar(&$o_PrestamoBean){ 
    $o_PrestamoDP = new PrestamoDP($o_PrestamoBean);
    return $o_PrestamoDP->save(); 
  }
  
  /**
  * Función para Modificar el  Prestamo
  *
  * @param $o_PrestamoBean, objeto bean de Prestamo
  * @return booleam
  */
  public function modificar(&$o_PrestamoBean){
    $o_PrestamoDP = new PrestamoDP($o_PrestamoBean);
    return $o_PrestamoDP->update();
  }
  
  /**
  * Función para Eliminar el  Prestamo
  *
  * @param $o_PrestamoBean, objeto bean de Prestamo
  * @return booleam
  */
  public function eliminar($o_PrestamoBean){ 
   $o_PrestamoDP = new PrestamoDP($o_PrestamoBean);
    return $o_PrestamoDP->delete();
  }
  
  /**
  * Función para Seleccionar el  Prestamo
  *
  * @param $o_PrestamoBeans, objeto bean de Prestamo
  * @return booleam
  */
  public function seleccionar($o_PrestamoBean){
  
    $o_PrestamoDP = new PrestamoDP($o_PrestamoBean);        
    if($o_PrestamoBean->getPrestamoId()){
      return $o_PrestamoDP->selectByPk();
    }else{
      return $o_PrestamoDP->select();
    }
      
  }
  public function totalMonto($o_PrestamoBean){
    $o_PrestamoBeanDP = new PrestamoDP($o_PrestamoBean);
    return $o_PrestamoBeanDP->selectTotalMonto();
    
  }
  
  public function totalRegistros($o_PrestamoBean){
    $o_PrestamoBeanDP = new PrestamoDP($o_PrestamoBean);
    return $o_PrestamoBeanDP->selectNumRows();
    
  }
  
}?>