<?php
/**
 * Clase ContPagoer para Pago
 *
 * @package    IM
 * @subpackage PagoCT
 * @author     Willy
 * @version    SVN: $Id: PagoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class PagoCT implements interfaceCT{
  /**
  * Funcin para Guardar el  Pago
  *
  * @param $o_PagoBean, objeto bean de Pago
  * @return booleam
  */
  public function guardar(&$o_PagoBean){ 
    $o_PagoDP = new PagoDP($o_PagoBean);
    return $o_PagoDP->save(); 
  }
  
  /**
  * Funcin para Modificar el  Pago
  *
  * @param $o_PagoBean, objeto bean de Pago
  * @return booleam
  */
  public function modificar(&$o_PagoBean){
    $o_PagoDP = new PagoDP($o_PagoBean);
    return $o_PagoDP->update();
  }
  
  /**
  * Funcin para Eliminar el  Pago
  *
  * @param $o_PagoBean, objeto bean de Pago
  * @return booleam
  */
  public function eliminar($o_PagoBean){ 
   $o_PagoDP = new PagoDP($o_PagoBean);
    return $o_PagoDP->delete();
  }
  
  /**
  * Funcin para Seleccionar el  Pago
  *
  * @param $o_PagoBeans, objeto bean de Pago
  * @return booleam
  */
  public function seleccionar($o_PagoBean){
  
    $o_PagoDP = new PagoDP($o_PagoBean);        
    if($o_PagoBean->getPagoId()){
      return $o_PagoDP->selectByPk();
    }else{
      return $o_PagoDP->select();
    }
      
  }
  
  public function totalRegistros($o_PagoBean){
    $o_PagoBeanDP = new PagoDP($o_PagoBean);
    return $o_PagoBeanDP->selectNumRows();
    
  }
  
}