<?php

/**
* Clase Dispacher para Mercado
*
* @package IM
* @subpackage MercadoDP
* @author Willy
* @version SVN: : MercadoDP.class.php,v 1.1 2009/05/24 13:18:31 Exp $
*/
class MercadoDP implements interfaceDP {
	private static $fieldNames = array (
    'Descripcion' => 'Descripcion'
	);
  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto MercadoBean
  *
  * @param MercadoBean $o_MercadoBean
  */
  public function __construct(MercadoBean $o_MercadoBean){
  
    $this->o_Bean = $o_MercadoBean;
    
  }
  
  /**
  * Retorna el objeto MercadoBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new MercadoBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      
      //if($this->getObjetoBean()->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getObjetoBean()->getIdMercado()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getDireccion()) : $a_Fields['Direccion'] = ($this->getObjetoBean()->getDireccion()); endif;
      if($this->getObjetoBean()->getTelefono()) : $a_Fields['Telefono'] = ($this->getObjetoBean()->getTelefono()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      
  
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO cr_mercado (".$sStringField.")
                      VALUES (".$sStringValue.");";
       //echo $sql;
      $iResultSave = $con->query($sql);
      $idMercado = $con->lastInsertId();
      $this->getObjetoBean()->setIdMercado($idMercado);
      
      
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
 
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  
  public function update() {

    if($this->getObjetoBean()->getIdMercado()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      if($this->getObjetoBean()->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getObjetoBean()->getIdMercado()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getDireccion()) : $a_Fields['Direccion'] = ($this->getObjetoBean()->getDireccion()); endif;
      if($this->getObjetoBean()->getTelefono()) : $a_Fields['Telefono'] = ($this->getObjetoBean()->getTelefono()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
	  if($this->getObjetoBean()->getFlagPermitirPrestamo()) : $a_Fields['FlagPermitirPrestamo'] = ($this->getObjetoBean()->getFlagPermitirPrestamo()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      $a_Fields['flagCC'] = '-1';
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_mercado SET
                  ".$sString."
            WHERE 1 AND IdMercado= '".$this->getObjetoBean()->getIdMercado()."' ";
      
      $result = $con->query($sql);
     
      
      //echo $sql;           
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    
      $o_Mercado = new MercadoBean();
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdMercado()){
          $o_Mercado->setIdMercado($this->getObjetoBean()->getIdMercado());
      }
            
      $sql = "UPDATE cr_mercado 
              SET
                Eliminado = '1',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdMercado= '".$this->getObjetoBean()->getIdMercado()."' ";
      
      $result = $con->query($sql);
      
      $num_rows = $result->rowCount();
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
   public function select(){
      
    $where = "";
        
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?999999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    if(trim($orden) =='') $orden = "ORDER BY IdMercado DESC";
    $con = Conexion::getConexion();
    $sql = "SELECT * 
    		FROM cr_mercado
            WHERE  Eliminado <> '1' ".$where." ".$orden.
            " LIMIT ".$limitInf.",".$tamPag;

    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    //echo $sql;
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }  
  
  /**
  * Retorna un objeto MercadoBean
  *
  * @return Object
  */
  
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * 
            FROM cr_mercado
            WHERE  IdMercado = '".$this->getObjetoBean()->getIdMercado()."' ";
    
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
     
   
    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }
       
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
 
  
  /**
  * Reasigna valores retornados del propel a un objeto MercadoBean
  *
  * @param Object $o_Propel
  * @return MercadoBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_MercadoBean = new MercadoBean();
    
    $o_MercadoBean->setIdMercado($o_Propel->IdMercado);
    $o_MercadoBean->setDescripcion($o_Propel->Descripcion);
    $o_MercadoBean->setDireccion($o_Propel->Direccion);
    $o_MercadoBean->setTelefono($o_Propel->Telefono);
    $o_MercadoBean->setEstado($o_Propel->Estado);
	$o_MercadoBean->setFlagPermitirPrestamo($o_Propel->flagPermitirPrestamo);
    $o_MercadoBean->setEliminado($o_Propel->Eliminado);
    $o_MercadoBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_MercadoBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_MercadoBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_MercadoBean->setFechaModificacion($o_Propel->FechaModificacion);
    $o_MercadoBean->setFechaEliminado($o_Propel->FechaEliminado);
    $o_MercadoBean->setUsuarioEliminado($o_Propel->UsuarioEliminado);
    
         
    return $o_MercadoBean;    
    
  }
  
  public function selectNumRows(){
    $where = $this->buildConsult();
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_mercado WHERE Eliminado <> '1'".$where;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    return $num_rows;
    
  }
  
  private function buildConsult(){
    
    $where = "";
    
    if($this->getObjetoBean()->getIdMercado()){
       $where .= " AND IdMercado  = '".$this->getObjetoBean()->getIdMercado()."'";
    }
    
    if($this->getObjetoBean()->getDescripcion()){
       $where .= " AND Descripcion like '%".$this->getObjetoBean()->getDescripcion()."%'";
    }
    
    if($this->getObjetoBean()->getEstado()){
        $where .= " AND Estado  = '".$this->getObjetoBean()->getEstado()."'";
    }
       
    if(is_array($this->getObjetoBean()->getIdMercadoAsignado())){
      	 $where .= " AND IdMercado not in ('".implode("','",$this->getObjetoBean()->getIdMercadoAsignado())."')";
    }
    
    if(is_array($this->getObjetoBean()->getIdMercados())){
      	 $where .= " AND IdMercado in ('".implode("','",$this->getObjetoBean()->getIdMercados())."')";
    }
	
    return $where;
  }
  
   public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
    
}

