<?php
/**
 * Clase ContMercadoRepresentanteer para MercadoRepresentante
 *
 * @package    IM
 * @subpackage MercadoRepresentanteCT
 * @author     Willy
 * @version    SVN: $Id: MercadoRepresentanteCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class MercadoRepresentanteCT implements interfaceCT{
  /**
  * Funcin para Guardar el  MercadoRepresentante
  *
  * @param $o_MercadoRepresentanteBean, objeto bean de MercadoRepresentante
  * @return booleam
  */
  public function guardar(&$o_MercadoRepresentanteBean){ 
      $o_MercadoRepresentanteDP = new MercadoRepresentanteDP($o_MercadoRepresentanteBean);
      $iResultado = $o_MercadoRepresentanteDP->save();        
      if($iResultado){
        return true;
      }else{
        return false;
      }
  }
  
  /**
  * Funcin para Modificar el  MercadoRepresentante
  *
  * @param $o_MercadoRepresentanteBean, objeto bean de MercadoRepresentante
  * @return booleam
  */
  public function modificar(&$o_MercadoRepresentanteBean){
    $o_MercadoRepresentanteDP = new MercadoRepresentanteDP($o_MercadoRepresentanteBean);
    $iResultado = $o_MercadoRepresentanteDP->update();        
    if($iResultado){
      return true;
    }else{
      return false;
    }
  }
  
  /**
  * Funcin para Eliminar el  MercadoRepresentante
  *
  * @param $o_MercadoRepresentanteBean, objeto bean de MercadoRepresentante
  * @return booleam
  */
  public function eliminar($o_MercadoRepresentanteBean){ 
    $o_MercadoRepresentanteDP = new MercadoRepresentanteDP($o_MercadoRepresentanteBean);
    $iResultado = $o_MercadoRepresentanteDP->delete();        
    if($iResultado){
      return true;
    }else{
      return false;
    }
  }
  
  
  /**
  * Funcin para Seleccionar el  MercadoRepresentante
  *
  * @param $o_MercadoRepresentanteBeans, objeto bean de MercadoRepresentante
  * @return booleam
  */
  public function seleccionar($o_MercadoRepresentanteBean){
  
    $o_MercadoRepresentanteDP = new MercadoRepresentanteDP($o_MercadoRepresentanteBean);        
    if($o_MercadoRepresentanteBean->getIdMercado()){
      return $o_MercadoRepresentanteDP->selectByPk();
    }else{
      return $o_MercadoRepresentanteDP->select();
    }
      
  }
  
}