<?php
/**
 * Clase MercadoBL
 *
 * @package    
 * @subpackage 
 * @author     MercadoBL
 * @version    SVN: $Id: MercadoBL.class.php,v 1.1 2008/02/08 21:56:44 william.taype Exp $ 
 */
class MercadoBL{
    
  /**
  * 
  *
  * @param $o_MercadoBean, objeto de tipo Mercado 
  * @return Boolean
  */
   public function getMercado(MercadoBean $o_MercadoBean){
    
    $o_MercadoCT = new MercadoCT();
    return $o_MercadoCT->seleccionar($o_MercadoBean);
    
  }
  
  public function busquedaMercado(MercadoBean $o_MercadoBean){
    
    $o_MercadoDP = new MercadoDP($o_MercadoBean);
    if($o_MercadoBean->getIdMercado()){
      return $o_MercadoDP->selectByPk();
    }else{
      return $o_MercadoDP->select();
    }
    
  }
  
  public function busquedaMercadoResulset(MercadoBean $o_MercadoBean){
    
    $o_MercadoDP = new MercadoDP($o_MercadoBean);
    return $o_MercadoDP->selectResultset();
        
  }
  
  /***************************************/
  
  public function insertarMercado(MercadoBean $o_MercadoBean){
    $o_MercadoCT = new MercadoCT();
    
    $bResult = $o_MercadoCT->guardar($o_MercadoBean);
    
    if($bResult){
      
      $a_tmp = $o_MercadoBean->getArrayMerColaborador();
      if(is_array($a_tmp)){
        foreach ($a_tmp as $o_MerColaboradorBean){
          
          $o_MerColaboradorBean->setIdMercado($o_MercadoBean->getIdMercado());
          
          $o_MerColaboradorBL = new MercadoRepresentanteBL();
          $bResult2 = $o_MerColaboradorBL->insertarMercadoRepresentante($o_MerColaboradorBean);
          
        }
      }
      
      return true;
      
    }else{
      
      $o_MercadoBean->setError(1);
      $o_MercadoBean->setMensaje("No se pudo insertar la cabecera Mercado");
      return false;
      
    }
    
    $o_MercadoCT->guardar($o_MercadoBean);
  }
  
  
  
  /***************************************/
  
  /*public function insertarMercado(MercadoBean $o_MercadoBean){
    
    $o_MercadoCT = new MercadoCT();
    return $o_MercadoCT->guardar($o_MercadoBean);
    
  }*/
  /*public function modificarMercado(MercadoBean $o_MercadoBean){
      $o_MercadoCT = new MercadoCT();
      return $o_MercadoCT->modificar($o_MercadoBean);
  }*/
  /**
	* Funcin que retorna un objeto Mercado o una lista de Objetos de Mercado,
	* dependiendo del parametro que se le envia si este contiene o no el Id de Mercado
	*
	* @param $o_MercadoBean, es un objeto de tipo Mercado
	* @return Object
	*/
	public function modificarEstadoMercado(MercadoBean $o_MercadoBean){
	  
	}
  
  public function eliminarMercado(MercadoBean $o_MercadoBean){
    $o_MercadoCT = new MercadoCT();
    return $o_MercadoCT->eliminar($o_MercadoBean);
    
  }
  
  public function getCountResult(MercadoBean $o_MercadoBean){
    $o_MercadoCT = new MercadoCT();
    return $o_MercadoCT->totalRegistros($o_MercadoBean);
  }
  
  public function busquedaMercadoDetalles(MercadoBean $o_MercadoBean){
        
    $o_Mercado = $this->busquedaMercado($o_MercadoBean);
    
    $o_MercadoRepresentanteBean = new MercadoRepresentanteBean();
    $o_MercadoRepresentanteBean->setIdMercado($o_Mercado[0]->getIdMercado());
    
    $o_MercadoRepresentanteBL = new MercadoRepresentanteBL();
    $a_tmpMercadoRepresentante = $o_MercadoRepresentanteBL->busquedaMercadoRepresentanteDetalle($o_MercadoRepresentanteBean);
    
    $o_Mercado[0]->setArrayMerColaborador($a_tmpMercadoRepresentante);
    
    return $o_Mercado;
  
  }
  
  public function modificarMercado(MercadoBean $o_MercadoBean){
    $o_MercadoCT = new MercadoCT();
    
    $bResult = $o_MercadoCT->modificar($o_MercadoBean);
    
    if($bResult){
      //Objeto temporal
      $tmp_ObjectMercado = $this->getMercado($o_MercadoBean);
      $o_MercadoBean->setIdMercado($o_MercadoBean->getIdMercado());
      
      //COLABORADOR      
      if(is_array($o_MercadoBean->getArrayMerColaboradorAct())){
        
        //estoy entregando del formulario
        $a_tmp = $o_MercadoBean->getArrayMerColaboradorAct();
        
        $o_MercadoRepresentanteBean = new MercadoRepresentanteBean();
        $o_MercadoRepresentanteBean->setIdMercado($o_MercadoBean->getIdMercado());
        
        $o_MercadoRepresentanteBL = new MercadoRepresentanteBL();
        //tengo en la base de datos
        $a_tmpMercadoRepresentante = $o_MercadoRepresentanteBL->busquedaMercadoRepresentanteDetalle($o_MercadoRepresentanteBean);
        
        foreach ($a_tmpMercadoRepresentante as $ikey => $o_MercadoRepresentanteBean){
            $bFound = false;
            foreach ($a_tmp as $ikeyUpd => $o_MercadoRepresentanteUpdateBean){
              
              if($o_MercadoRepresentanteBean->getIdColaborador() == $o_MercadoRepresentanteUpdateBean->getIdColaborador()){
                $o_MercadoRepresentanteBL = new MercadoRepresentanteBL();
                $bResult = $o_MercadoRepresentanteBL->modificarEstadoMercadoRepresentante($o_MercadoRepresentanteUpdateBean);
                $bFound = true;
                break;
              }
              
            }
            
            if(!$bFound){
              $o_MercadoRepresentanteBL = new MercadoRepresentanteBL();
              $bResult = $o_MercadoRepresentanteBL->eliminarMercadoRepresentante($o_MercadoRepresentanteBean);
            }
            
        }
      
     }else{
        
        $bResultEliminarMColaborador = $this->EliminarMColaboradorPorIdMercado($o_MercadoBean);
        
     }
      
      if(is_array($o_MercadoBean->getArrayMerColaborador())){
        
        $a_tmp = $o_MercadoBean->getArrayMerColaborador();
        
        foreach ($a_tmp as $o_MercadoRepresentanteBean){
          $o_MercadoRepresentanteBean->setIdMercado($o_MercadoRepresentanteBean->getIdMercado());
          
          $o_MercadoRepresentanteBL = new MercadoRepresentanteBL();
          $bResult2 = $o_MercadoRepresentanteBL->insertarMercadoRepresentante($o_MercadoRepresentanteBean);
          
        }
        
      }
   }
    return true;
    
  }
    public function EliminarMColaboradorPorIdMercado(MercadoBean $o_MercadoBean){
    
    $o_MercadoRepresentanteBean = new MercadoRepresentanteBean();
    $o_MercadoRepresentanteBean->setIdMercado($o_MercadoBean->getIdMercado());
    $o_MercadoRepresentanteBL = new MercadoRepresentanteBL();
    return $o_MercadoRepresentanteBL->eliminarMercadoRepresentante($o_MercadoRepresentanteBean);
    
  } 
  
}

