<?php

/**
* Clase Dispacher para DocumentoCliente
*
* @package IM
* @subpackage DocumentoClienteDP
* @author Willy
* @version SVN: : DocumentoClienteDP.class.php,v 1.1 2009/06/09 15:08:14 Exp $
*/
class DocumentoClienteDP implements interfaceDP {

  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto DocumentoClienteBean
  *
  * @param DocumentoClienteBean $o_DocumentoClienteBean
  */
  public function __construct(DocumentoClienteBean $o_DocumentoClienteBean){
  
    $this->o_Bean = $o_DocumentoClienteBean;
    
  }
  
  /**
  * Retorna el objeto DocumentoClienteBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new DocumentoClienteBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  
  public function save(){

    
   if($this->getObjetoBean()->getIdCliente()){

      $a_Fields = array();

      if($this->getObjetoBean()->getIdCliente()) : $a_Fields['IdCliente'] = ($this->getObjetoBean()->getIdCliente()); endif;
      if($this->getObjetoBean()->getIdDocumento()) : $a_Fields['IdDocumento'] = ($this->getObjetoBean()->getIdDocumento()); endif;
      
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";
        
      $con = Conexion::getConexion();
      $sql = "INSERT INTO cr_documeto_cliente  (".$sStringField.")
                      VALUES (".$sStringValue.");";
      //echo $sql;
      $result = $con->query($sql);
      

      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }
  }

  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  
  public function update() {

     if($this->getObjetoBean()->getIdCliente()){
      
      if($this->getObjetoBean()->getIdCliente()) : $a_Fields['IdCliente'] = ($this->getObjetoBean()->getIdCliente()); endif;
      if($this->getObjetoBean()->getIdDocumento()) : $a_Fields['IdDocumento'] = ($this->getObjetoBean()->getIdDocumento()); endif;
      
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);
      $con = Conexion::getConexion();
       
      $sql = "UPDATE  cr_documeto_cliente SET
                  ".$sString."
              WHERE 1 AND IdCliente = '".$this->getObjetoBean()->getIdCliente()."' ";
      
      $result = $con->query($sql);
      

      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  
  public function delete(){
     $where = "";
    
    if($this->getObjetoBean()->getIdCliente ()){
       $where .= " AND IdCliente  = '".$this->getObjetoBean()->getIdCliente ()."'";
    }
    
    if($this->getObjetoBean()->getIdDocumento()){
       $where .= " AND IdDocumento = '".$this->getObjetoBean()->getIdDocumento()."'";
    }
       
    
    $con = Conexion::getConexion();
    $sql = "DELETE FROM   
    		cr_documeto_cliente 
    		WHERE 1 ".$where;
    $result = $con->query($sql);
    

    $iResultSave = $result;
    if($iResultSave > 0){
      return $iResultSave;
    }else{
      return false;
    }
  }
  
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
      
    $where = "";
    
    if($this->getObjetoBean()->getIdCliente()){
       $where .= " AND IdCliente  = '".$this->getObjetoBean()->getIdCliente()."'";
    } if($this->getObjetoBean()->getIdDocumento()){
       $where .= " AND IdDocumento = '".$this->getObjetoBean()->getIdDocumento()."'";
    }
    
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_documeto_cliente WHERE 1 ".$where;
    //echo $sql;
    $result = $con->query($sql);
    
    $num_rows = $result->rowCount();
      
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  /**
  * Retorna un objeto DocumentoClienteBean
  *
  * @return Object
  */
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_documeto_cliente WHERE 1 AND IdCliente = '".$this->getObjetoBean()->getIdCliente()."'";
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
 
    $a_tmp = array();   
     
    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }
   
    return count($a_tmp)>0?$a_tmp:null;
  
  }
  
  
   /**
  * Reasigna valores retornados del propel a un objeto DocumentoClienteBean
  *
  * @param Object $o_Propel
  * @return DocumentoClienteBean
  */
   
  private function insertarObjetoBean($o_Propel){

    $o_DocumentoClienteBean = new DocumentoClienteBean();
    
    $o_DocumentoClienteBean->setIdCliente($o_Propel->IdCliente);
    $o_DocumentoClienteBean->setIdDocumento($o_Propel->IdDocumento);
    
    return $o_DocumentoClienteBean;    
    
  }
    
}

