<?php
/**
 * Clase ContDocumentoClienteer para DocumentoCliente
 *
 * @package    IM
 * @subpackage DocumentoClienteCT
 * @author     Willy
 * @version    SVN: $Id: DocumentoClienteCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class DocumentoClienteCT implements interfaceCT{
  /**
  * Funcin para Guardar el  DocumentoCliente
  *
  * @param $o_DocumentoClienteBean, objeto bean de DocumentoCliente
  * @return booleam
  */
  public function guardar(&$o_DocumentoClienteBean){ 
      $o_DocumentoClienteDP = new DocumentoClienteDP($o_DocumentoClienteBean);
      $iResultado = $o_DocumentoClienteDP->save();        
      if($iResultado){
        return true;
      }else{
        return false;
      }
  }
  
  /**
  * Funcin para Modificar el  DocumentoCliente
  *
  * @param $o_DocumentoClienteBean, objeto bean de DocumentoCliente
  * @return booleam
  */
  public function modificar(&$o_DocumentoClienteBean){
    $o_DocumentoClienteDP = new DocumentoClienteDP($o_DocumentoClienteBean);
    $iResultado = $o_DocumentoClienteDP->update();        
    if($iResultado){
      return true;
    }else{
      return false;
    }
  }
  
  /**
  * Funcin para Eliminar el  DocumentoCliente
  *
  * @param $o_DocumentoClienteBean, objeto bean de DocumentoCliente
  * @return booleam
  */
  public function eliminar($o_DocumentoClienteBean){ 
    $o_DocumentoClienteDP = new DocumentoClienteDP($o_DocumentoClienteBean);
    $iResultado = $o_DocumentoClienteDP->delete();        
    if($iResultado){
      return true;
    }else{
      return false;
    }
  }
  
  
  /**
  * Funcin para Seleccionar el  DocumentoCliente
  *
  * @param $o_DocumentoClienteBeans, objeto bean de DocumentoCliente
  * @return booleam
  */
  public function seleccionar($o_DocumentoClienteBean){
  
    $o_DocumentoClienteDP = new DocumentoClienteDP($o_DocumentoClienteBean);        
    return $o_DocumentoClienteDP->select();
      
  }
  
}