<?php
/**
 * Clase ContClienteer para Cliente
 *
 * @package    IM
 * @subpackage ClienteCT
 * @author     Willy
 * @version    SVN: $Id: ClienteCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class ClienteCT implements interfaceCT{
  /**
  * Función para Guardar el  Cliente
  *
  * @param $o_ClienteBean, objeto bean de Cliente
  * @return booleam
  */
  public function guardar(&$o_ClienteBean){ 
    
    $o_ClienteDP = new ClienteDP($o_ClienteBean);
    return $o_ClienteDP->save();
    
  }
  
  /**
  * Función para Modificar el  Cliente
  *
  * @param $o_ClienteBean, objeto bean de Cliente
  * @return booleam
  */
  public function modificar(&$o_ClienteBean){
    
    $o_ClienteDP = new ClienteDP($o_ClienteBean);
    return $o_ClienteDP->update();
    
  }
  
  /**
  * Función para Eliminar el  Cliente
  *
  * @param $o_ClienteBean, objeto bean de Cliente
  * @return booleam
  */
  public function eliminar($o_ClienteBean){ 
    $o_ClienteDP = new ClienteDP($o_ClienteBean);
    return $o_ClienteDP->delete();
  }
  
  
  public function totalRegistros($o_ClienteBean){
    $o_ClienteBeanDP = new ClienteDP($o_ClienteBean);
    return $o_ClienteBeanDP->selectNumRows();
    
  } 
  
  public function tienePrestamo($o_ClienteBean){
    $o_ClienteBeanDP = new ClienteDP($o_ClienteBean);
    return $o_ClienteBeanDP->TienePrestamo();
    
  }
  
  
  /**
  * Función para Seleccionar el  Cliente
  *
  * @param $o_ClienteBeans, objeto bean de Cliente
  * @return booleam
  */
  public function seleccionar($o_ClienteBean){
  
    $o_ClienteDP = new ClienteDP($o_ClienteBean);
    if($o_ClienteBean->getClienteId()){
      return $o_ClienteDP->selectByPk();
    }else{
      return $o_ClienteDP->select();
    }
      
  }
  
}