<?php
class utilValidDataType
{
	// Mensaje de validacion ( inconsistencia ).
    protected $s_Message;

    // Devuelve el mensaje de validaci�n.
    public function getMessage()
    {
        return $this->s_Message;
    }

    // Valida el datos segun el tipo de dato, lengitud, decimales y si es un dato requerido ( not null ).
    public function validate( $u_Value, $s_DataType, $i_Len = 0, $i_Pression = 0, $b_NotNull = false )
    {
        try {
            $this->s_Message = null;
            if ( $b_NotNull && is_null( $u_Value ) )
            {
                throw new Exception( "Es un campo requerido, no debe ser nulo." );
            }
            if ( !is_null( $u_Value ) )
            {
                switch ( strtoupper( $s_DataType ) )
                {
                    case "TEXT":        // Dominio
                    case "STRING":        // Dominio
                    case "CHAR":        // Tipo de dato
                    case "VARCHAR":        // Tipo de dato
                    case "VARCHAR2":        // Tipo de dato
                        $u_Value = ( $u_Value );
                        if ( !is_string( $u_Value ) )
                        {
                            throw new Exception( "No es una cadena." );
                        }
                        if ( ( $i_Len > 0 ) && ( strlen( $u_Value ) > $i_Len ) )
                        {
                            throw new Exception( "Excede la longitud de caracteres." );
                        }
                        if ( strpos( $u_Value, chr(9) ) !== false || strpos( $u_Value, chr( 195 ) ) !== false )
                        {
                            throw new Exception( "No debe contener caracteres especiales." );
                        }
                        break;
                        
                    case "TINYINT":     // Tipo de dato
                    case "SMALLINT":    // Tipo de dato
                    case "INT":         // Tipo de dato
                    case "INTEGER":     // Tipo de dato
                    case "BIGINT":      // Tipo de dato
                        if ( !is_int( $u_Value ) )
                        {
                            throw new Exception( "No es un numero entero." );
                        }
                        if ( ( $i_Len > 0 ) && $u_Value > 0 && strlen( (string) $u_Value ) > $i_Len )
                        {
                            throw new Exception( "Excede la longitud de enteros." );
                        }
                        break;
                        
                    case "NUMBER":      // Dominio
                    case "NUMERIC":     // Tipo de dato
                    case "DECIMAL":     // Tipo de dato
                    case "DOUBLE":      // Tipo de dato
                    case "REAL":      // Tipo de dato
                    case "FLOAT":       // Tipo de dato
                        if ( !is_float( $u_Value ) && !is_int( $u_Value ) )
                        {
                            throw new Exception( "No es un numero decimal." );
                        }
                        $s_Value = ( string ) $u_Value;
                        $a_Value = explode( ".", $s_Value );
                        if ( ( $i_Len > 0 ) && ( strlen( $a_Value[ 0 ] ) > $i_Len ) )
                        {
                            throw new Exception( "Excede la longitud de enteros." );
                        }
                        if ( ( $i_Pression > 0 ) && isset( $a_Value[ 1 ] ) && ( strlen( $a_Value[ 1 ] ) > $i_Pression ) )
                        {
                            throw new Exception( "Excede la longitud de decimales." );
                        }
                        break;
                    
                    case "DATETIME":    // Dominio, Tipo de dato
                    case "DATE":        // Tipo de dato
                    case "TIMESTAMP":   // Tipo de dato
                        if ( strtotime( $u_Value ) === -1 || strtotime( $u_Value ) === false )
                        {
                            throw new Exception( "No tiene un formato de fecha valido." );
                        }
                        break;
                        
                    default:
                        throw new Exception( "No tiene un tipo de dato definido." );
                        break;
                }
            }
        }
        catch ( Exception $oError )
        {
            $this->s_Message = $oError->getMessage();
        }
        return is_null( $this->s_Message );
    }
    
    // Devuelve una cadena sin caracteres especiales.
    public static function castString( $s_String )
    {
        // Nota.- trim() elimina estos caracteres: 
        // - Espacio simple
        // - Tabulacion
        // - Salto de linea
        // - Retorno de carro
        // - Byte NUL
        // - Tabulacion vertical.
        $s_String = trim( $s_String );
        return $s_String;
    }
}