<?php
/* Autor...: Grupo Deltron S.A. */
/* Esquema.: cr_alfa_extension_15082014.xml */
/* Generado: 2014-08-26 22:08:08 */

/* Busqueda de registros de la tabla cr_tipo_file. */
abstract class BaseCr_tipo_fileFN extends Cr_tipo_fileBN
{
    /* Declaracion de constantes */
    const Idtipofile = "IDTIPOFILE";
    const Descripcion = "DESCRIPCION";
    const Estado = "ESTADO";
    const View = "VIEW";
    const FechaRegistro = "FECHAREGISTRO";
    const UsuarioRegistro = "USUARIOREGISTRO";
    const Eliminado = "ELIMINADO";
    const FechaEliminado = "FECHAELIMINADO";
    const UsuarioEliminado = "USUARIOELIMINADO";
    const SqlDes = "SQLDES";

    public $a_Condition = array();
    public $a_OrderBy = array();

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion2::getConexion();
        $o_Resource = $o_DBConnect->getResource();
        return $o_Resource;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "idtipofile AS idtipofile, ";
        $s_SQLQuery .= "Descripcion AS Descripcion, ";
        $s_SQLQuery .= "Estado AS Estado, ";
        $s_SQLQuery .= "View AS View, ";
        $s_SQLQuery .= "FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "Eliminado AS Eliminado, ";
        $s_SQLQuery .= "FechaEliminado AS FechaEliminado, ";
        $s_SQLQuery .= "UsuarioEliminado AS UsuarioEliminado, ";
        $s_SQLQuery .= "SqlDes AS SqlDes ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece los valores desde un objeto Cr_tipo_fileBN */
    public function setByBN( Cr_tipo_fileBN $o_Cr_tipo_fileBN )
    {
        if ( !is_null( $o_Cr_tipo_fileBN->getIdtipofile() ) )
        {
            $this->setIdtipofile( $o_Cr_tipo_fileBN->getIdtipofile() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_Cr_tipo_fileBN->getDescripcion() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getEstado() ) )
        {
            $this->setEstado( $o_Cr_tipo_fileBN->getEstado() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getView() ) )
        {
            $this->setView( $o_Cr_tipo_fileBN->getView() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_Cr_tipo_fileBN->getFechaRegistro() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_Cr_tipo_fileBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getEliminado() ) )
        {
            $this->setEliminado( $o_Cr_tipo_fileBN->getEliminado() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_Cr_tipo_fileBN->getFechaEliminado() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_Cr_tipo_fileBN->getUsuarioEliminado() );
        }
        if ( !is_null( $o_Cr_tipo_fileBN->getSqlDes() ) )
        {
            $this->setSqlDes( $o_Cr_tipo_fileBN->getSqlDes() );
        }
    }

    /* Busca un registro por su llave primaria */
    public function selectByPK( $i_Idtipofile )
    {
        if( is_null( $i_Idtipofile ) ){ $i_Idtipofile = -1; }

        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM cr_tipo_file ";
        $s_SQLQuery .= "WHERE idtipofile = ".$i_Idtipofile." ";
        $s_SQLQuery .= "LIMIT 1;";

        $o_Cr_tipo_fileBN = null;
        $o_Resource = $this->getConnect();
        $o_SQLResult = $o_Resource->query($s_SQLQuery);
        if ( $o_SQLResult === false )
        {
            throw new Exception( $con->errorInfo() );
        }
        if ( $a_SQLRow = $o_SQLResult->fetch(PDO::FETCH_OBJ) )
        {
            $o_Cr_tipo_fileBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_Cr_tipo_fileBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdtipofile() ) ) $s_SQLQuery .= "idtipofile = ".$this->getIdtipofile()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getView() ) ) $s_SQLQuery .= "View = '".$this->getView()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getEliminado() ) ) $s_SQLQuery .= "Eliminado = ".$this->getEliminado()." AND ";
        if ( !is_null( $this->getFechaEliminado() ) ) $s_SQLQuery .= "FechaEliminado = '".$this->getFechaEliminado()."' AND ";
        if ( !is_null( $this->getUsuarioEliminado() ) ) $s_SQLQuery .= "UsuarioEliminado = '".$this->getUsuarioEliminado()."' AND ";
        if ( !is_null( $this->getSqlDes() ) ) $s_SQLQuery .= "SqlDes = '".$this->getSqlDes()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM cr_tipo_file WHERE ";
        $s_SQLQuery .= $this->buildConsult();

        $o_Resource = $this->getConnect();
        $o_SQLResult = $o_Resource->query($s_SQLQuery);
        if ( $o_SQLResult === false )
        {
            throw new Exception( $con->errorInfo() );
        }

        $num_rows = 0;
        if ( $a_SQLRow = $o_SQLResult->fetch(PDO::FETCH_OBJ) )
        {
            $num_rows = $a_SQLRow->cnt;
        }
        return $num_rows;
    }

    /* Busca varios registros por los campos establecidos */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM cr_tipo_file WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_Cr_tipo_fileBN = null;
        $o_Resource = $this->getConnect();
        $o_SQLResult = $o_Resource->query($s_SQLQuery);
        if ( $o_SQLResult === false )
        {
            throw new Exception( $con->errorInfo() );
        }
        while ( $a_SQLRow = $o_SQLResult->fetch(PDO::FETCH_OBJ) )
        {
            $o_Cr_tipo_fileBN = $this->insertObjectBN( $a_SQLRow );
            $a_Cr_tipo_fileBN[] = $o_Cr_tipo_fileBN;
        }
        return $a_Cr_tipo_fileBN;
    }

    /* Devuelve un objeto Cr_tipo_fileBN desde un objeto propel */
    public function insertObjectBN( $o_Cr_tipo_file )
    {
        $o_Cr_tipo_fileBN = new Cr_tipo_fileBN();
        if ( !is_null( $o_Cr_tipo_file->idtipofile ) ) $o_Cr_tipo_fileBN->setIdtipofile( ( integer ) $o_Cr_tipo_file->idtipofile );
        if ( !is_null( $o_Cr_tipo_file->Descripcion ) ) $o_Cr_tipo_fileBN->setDescripcion( $o_Cr_tipo_file->Descripcion );
        if ( !is_null( $o_Cr_tipo_file->Estado ) ) $o_Cr_tipo_fileBN->setEstado( $o_Cr_tipo_file->Estado );
        if ( !is_null( $o_Cr_tipo_file->View ) ) $o_Cr_tipo_fileBN->setView( $o_Cr_tipo_file->View );
        if ( !is_null( $o_Cr_tipo_file->FechaRegistro ) ) $o_Cr_tipo_fileBN->setFechaRegistro( utilTimestamp::getTimestamp( $o_Cr_tipo_file->FechaRegistro, "Y-m-d" ) );
        if ( !is_null( $o_Cr_tipo_file->UsuarioRegistro ) ) $o_Cr_tipo_fileBN->setUsuarioRegistro( $o_Cr_tipo_file->UsuarioRegistro );
        if ( !is_null( $o_Cr_tipo_file->Eliminado ) ) $o_Cr_tipo_fileBN->setEliminado( ( integer ) $o_Cr_tipo_file->Eliminado );
        if ( !is_null( $o_Cr_tipo_file->FechaEliminado ) ) $o_Cr_tipo_fileBN->setFechaEliminado( utilTimestamp::getTimestamp( $o_Cr_tipo_file->FechaEliminado, "Y-m-d" ) );
        if ( !is_null( $o_Cr_tipo_file->UsuarioEliminado ) ) $o_Cr_tipo_fileBN->setUsuarioEliminado( $o_Cr_tipo_file->UsuarioEliminado );
        if ( !is_null( $o_Cr_tipo_file->SqlDes ) ) $o_Cr_tipo_fileBN->setSqlDes( $o_Cr_tipo_file->SqlDes );
        return $o_Cr_tipo_fileBN;
    }
}
?>