<?php
/* Autor...: Grupo Deltron S.A. */
/* Esquema.: cr_alfa_extension_15082014.xml */
/* Generado: 2014-08-26 22:08:08 */

/* Busqueda de registros de la tabla cr_prestamo_file. */
abstract class BaseCr_prestamo_fileFN extends Cr_prestamo_fileBN
{
    /* Declaracion de constantes */
    const IdPrestamoFile = "IDPRESTAMOFILE";
    const IdPrestamo = "IDPRESTAMO";
    const IdCliente = "IDCLIENTE";
    const Estado = "ESTADO";
    const FileNumero = "FILENUMERO";
    const NombreFile = "NOMBREFILE";
    const FechaRegistro = "FECHAREGISTRO";
    const UsuarioRegistro = "USUARIOREGISTRO";
    const Eliminado = "ELIMINADO";
    const FechaEliminado = "FECHAELIMINADO";
    const UsuarioEliminado = "USUARIOELIMINADO";
    const FechaModificacion = "FECHAMODIFICACION";
    const UsuarioModificacion = "USUARIOMODIFICACION";
    const Comentario = "COMENTARIO";
    const Idtipofile = "IDTIPOFILE";

    public $a_Condition = array();
    public $a_OrderBy = array();

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion2::getConexion();
        $o_Resource = $o_DBConnect->getResource();
        return $o_Resource;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "IdPrestamoFile AS IdPrestamoFile, ";
        $s_SQLQuery .= "IdPrestamo AS IdPrestamo, ";
        $s_SQLQuery .= "idcliente AS IdCliente, ";
        $s_SQLQuery .= "Estado AS Estado, ";
        $s_SQLQuery .= "FileNumero AS FileNumero, ";
        $s_SQLQuery .= "NombreFile AS NombreFile, ";
        $s_SQLQuery .= "FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "Eliminado AS Eliminado, ";
        $s_SQLQuery .= "FechaEliminado AS FechaEliminado, ";
        $s_SQLQuery .= "UsuarioEliminado AS UsuarioEliminado, ";
        $s_SQLQuery .= "FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "Comentario AS Comentario, ";
        $s_SQLQuery .= "idtipofile AS idtipofile ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece los valores desde un objeto Cr_prestamo_fileBN */
    public function setByBN( Cr_prestamo_fileBN $o_Cr_prestamo_fileBN )
    {
        if ( !is_null( $o_Cr_prestamo_fileBN->getIdPrestamoFile() ) )
        {
            $this->setIdPrestamoFile( $o_Cr_prestamo_fileBN->getIdPrestamoFile() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getIdPrestamo() ) )
        {
            $this->setIdPrestamo( $o_Cr_prestamo_fileBN->getIdPrestamo() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getIdCliente() ) )
        {
            $this->setIdCliente( $o_Cr_prestamo_fileBN->getIdCliente() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getEstado() ) )
        {
            $this->setEstado( $o_Cr_prestamo_fileBN->getEstado() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getFileNumero() ) )
        {
            $this->setFileNumero( $o_Cr_prestamo_fileBN->getFileNumero() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getNombreFile() ) )
        {
            $this->setNombreFile( $o_Cr_prestamo_fileBN->getNombreFile() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_Cr_prestamo_fileBN->getFechaRegistro() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_Cr_prestamo_fileBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getEliminado() ) )
        {
            $this->setEliminado( $o_Cr_prestamo_fileBN->getEliminado() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_Cr_prestamo_fileBN->getFechaEliminado() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_Cr_prestamo_fileBN->getUsuarioEliminado() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_Cr_prestamo_fileBN->getFechaModificacion() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_Cr_prestamo_fileBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getComentario() ) )
        {
            $this->setComentario( $o_Cr_prestamo_fileBN->getComentario() );
        }
        if ( !is_null( $o_Cr_prestamo_fileBN->getIdtipofile() ) )
        {
            $this->setIdtipofile( $o_Cr_prestamo_fileBN->getIdtipofile() );
        }
    }

    /* Busca un registro por su llave primaria */
    public function selectByPK( $i_IdPrestamoFile )
    {
        if( is_null( $i_IdPrestamoFile ) ){ $i_IdPrestamoFile = -1; }

        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM cr_prestamo_file ";
        $s_SQLQuery .= "WHERE IdPrestamoFile = ".$i_IdPrestamoFile." ";
        $s_SQLQuery .= "LIMIT 1;";

        $o_Cr_prestamo_fileBN = null;
        $o_Resource = $this->getConnect();
        $o_SQLResult = $o_Resource->query($s_SQLQuery);
        if ( $o_SQLResult === false )
        {
            throw new Exception( $con->errorInfo() );
        }
        if ( $a_SQLRow = $o_SQLResult->fetch(PDO::FETCH_OBJ) )
        {
            $o_Cr_prestamo_fileBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_Cr_prestamo_fileBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPrestamoFile() ) ) $s_SQLQuery .= "IdPrestamoFile = ".$this->getIdPrestamoFile()." AND ";
        if ( !is_null( $this->getIdPrestamo() ) ) $s_SQLQuery .= "IdPrestamo = ".$this->getIdPrestamo()." AND ";
        if ( !is_null( $this->getIdCliente() ) ) $s_SQLQuery .= "idcliente = ".$this->getIdCliente()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFileNumero() ) ) $s_SQLQuery .= "FileNumero = '".$this->getFileNumero()."' AND ";
        if ( !is_null( $this->getNombreFile() ) ) $s_SQLQuery .= "NombreFile = '".$this->getNombreFile()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getEliminado() ) ) $s_SQLQuery .= "Eliminado = ".$this->getEliminado()." AND ";
        if ( !is_null( $this->getFechaEliminado() ) ) $s_SQLQuery .= "FechaEliminado = '".$this->getFechaEliminado()."' AND ";
        if ( !is_null( $this->getUsuarioEliminado() ) ) $s_SQLQuery .= "UsuarioEliminado = '".$this->getUsuarioEliminado()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getIdtipofile() ) ) $s_SQLQuery .= "idtipofile = ".$this->getIdtipofile()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM cr_prestamo_file WHERE ";
        $s_SQLQuery .= $this->buildConsult();

        $o_Resource = $this->getConnect();
        $o_SQLResult = $o_Resource->query($s_SQLQuery);
        if ( $o_SQLResult === false )
        {
            throw new Exception( $con->errorInfo() );
        }

        $num_rows = 0;
        if ( $a_SQLRow = $o_SQLResult->fetch(PDO::FETCH_OBJ) )
        {
            $num_rows = $a_SQLRow->cnt;
        }
        return $num_rows;
    }

    /* Busca varios registros por los campos establecidos */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM cr_prestamo_file WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_Cr_prestamo_fileBN = null;
        $o_Resource = $this->getConnect();
        $o_SQLResult = $o_Resource->query($s_SQLQuery);
        if ( $o_SQLResult === false )
        {
            throw new Exception( $con->errorInfo() );
        }
        while ( $a_SQLRow = $o_SQLResult->fetch(PDO::FETCH_OBJ) )
        {
            $o_Cr_prestamo_fileBN = $this->insertObjectBN( $a_SQLRow );
            $a_Cr_prestamo_fileBN[] = $o_Cr_prestamo_fileBN;
        }
        return $a_Cr_prestamo_fileBN;
    }

    /* Devuelve un objeto Cr_prestamo_fileBN desde un objeto propel */
    public function insertObjectBN( $o_Cr_prestamo_file )
    {
        $o_Cr_prestamo_fileBN = new Cr_prestamo_fileBN();
        if ( !is_null( $o_Cr_prestamo_file->IdPrestamoFile ) ) $o_Cr_prestamo_fileBN->setIdPrestamoFile( ( integer ) $o_Cr_prestamo_file->IdPrestamoFile );
        if ( !is_null( $o_Cr_prestamo_file->IdPrestamo ) ) $o_Cr_prestamo_fileBN->setIdPrestamo( ( float ) $o_Cr_prestamo_file->IdPrestamo );
        if ( !is_null( $o_Cr_prestamo_file->IdCliente ) ) $o_Cr_prestamo_fileBN->setIdCliente( ( integer ) $o_Cr_prestamo_file->IdCliente );
        if ( !is_null( $o_Cr_prestamo_file->Estado ) ) $o_Cr_prestamo_fileBN->setEstado( $o_Cr_prestamo_file->Estado );
        if ( !is_null( $o_Cr_prestamo_file->FileNumero ) ) $o_Cr_prestamo_fileBN->setFileNumero( $o_Cr_prestamo_file->FileNumero );
        if ( !is_null( $o_Cr_prestamo_file->NombreFile ) ) $o_Cr_prestamo_fileBN->setNombreFile( $o_Cr_prestamo_file->NombreFile );
        if ( !is_null( $o_Cr_prestamo_file->FechaRegistro ) ) $o_Cr_prestamo_fileBN->setFechaRegistro( utilTimestamp::getTimestamp( $o_Cr_prestamo_file->FechaRegistro, "Y-m-d" ) );
        if ( !is_null( $o_Cr_prestamo_file->UsuarioRegistro ) ) $o_Cr_prestamo_fileBN->setUsuarioRegistro( $o_Cr_prestamo_file->UsuarioRegistro );
        if ( !is_null( $o_Cr_prestamo_file->Eliminado ) ) $o_Cr_prestamo_fileBN->setEliminado( ( integer ) $o_Cr_prestamo_file->Eliminado );
        if ( !is_null( $o_Cr_prestamo_file->FechaEliminado ) ) $o_Cr_prestamo_fileBN->setFechaEliminado( utilTimestamp::getTimestamp( $o_Cr_prestamo_file->FechaEliminado, "Y-m-d" ) );
        if ( !is_null( $o_Cr_prestamo_file->UsuarioEliminado ) ) $o_Cr_prestamo_fileBN->setUsuarioEliminado( $o_Cr_prestamo_file->UsuarioEliminado );
        if ( !is_null( $o_Cr_prestamo_file->FechaModificacion ) ) $o_Cr_prestamo_fileBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_Cr_prestamo_file->FechaModificacion, "Y-m-d" ) );
        if ( !is_null( $o_Cr_prestamo_file->UsuarioModificacion ) ) $o_Cr_prestamo_fileBN->setUsuarioModificacion( $o_Cr_prestamo_file->UsuarioModificacion );
        if ( !is_null( $o_Cr_prestamo_file->Comentario ) ) $o_Cr_prestamo_fileBN->setComentario( $o_Cr_prestamo_file->Comentario );
        if ( !is_null( $o_Cr_prestamo_file->idtipofile ) ) $o_Cr_prestamo_fileBN->setIdtipofile( ( integer ) $o_Cr_prestamo_file->idtipofile );
        return $o_Cr_prestamo_fileBN;
    }
}
?>