<?php

class sfCore {
  
  static protected
  $autoloadCallables = array(),
  $classes           = array();
  
  static public function addAutoloadCallable($callable){
    self::$autoloadCallables[] = $callable;
    if (function_exists('spl_autoload_register'))
    {
      spl_autoload_register($callable);
    }
  }
  
  static public function initAutoload(){
    /*
    if (function_exists('spl_autoload_register')){
      ini_set('unserialize_callback_func', 'spl_autoload_call');
    }else if (!function_exists('__autoload')){
      
      ini_set('unserialize_callback_func', '__autoload');
      
      function __autoload($class){
        
        foreach (sfCore::getAutoloadCallables() as $callable){
          if (call_user_func($callable, $class)){
            return true;
          }
        }

        // unspecified class
        // do not print an error if the autoload came from class_exists
        $trace = debug_backtrace();
        if (count($trace) < 1 || ($trace[1]['function'] != 'class_exists' && $trace[1]['function'] != 'is_a'))
        {
          $error = sprintf('Autoloading of class "%s" failed. Try to clear the symfony cache and refresh. [err0003]', $class);
          $e = new sfAutoloadException($error);

          $e->printStackTrace();
        }
      }
    }
    */
    
    if (!self::$classes){
      $file = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'config_autoload.php';
      self::$classes = include($file);
    }
    
    self::addAutoloadCallable(array('sfCore', 'splSimpleAutoload'));
  }
  
  static public function splSimpleAutoload($class){
    // class already exists
    if (class_exists($class, false)){
      return true;
    }

    // we have a class path, let's include it
    if (isset(self::$classes[$class])){
      require(self::$classes[$class]);
      return true;
    }

    return false;
  }
    
}

