<?php
/**
 * Clase Base DP para BaseArValorDP
 *
 * @package    
 * @subpackage BaseArValorDP
 * @author     Willy
 * @version    SVN:: BaseArValorDP.class.php,v 1.1 2020-06-30 13:51:18 william.taype Exp $
 */
abstract class BaseArValorDP extends ArValorBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArValorBN )
    {
      $o_ArValorBN = $bSetDefault;
      if($o_ArValorBN->getIdvalor()) : $this->setIdvalor($o_ArValorBN->getIdvalor()); endif;
      if($o_ArValorBN->getTipovalor()) : $this->setTipovalor($o_ArValorBN->getTipovalor()); endif;
      if($o_ArValorBN->getDescripcion()) : $this->setDescripcion($o_ArValorBN->getDescripcion()); endif;
      if($o_ArValorBN->getValor()) : $this->setValor($o_ArValorBN->getValor()); endif;
      if($o_ArValorBN->getTopeminimo()) : $this->setTopeminimo($o_ArValorBN->getTopeminimo()); endif;
      if($o_ArValorBN->getTopemaximo()) : $this->setTopemaximo($o_ArValorBN->getTopemaximo()); endif;
      if($o_ArValorBN->getEstado()) : $this->setEstado($o_ArValorBN->getEstado()); endif;
      if($o_ArValorBN->getEliminado()) : $this->setEliminado($o_ArValorBN->getEliminado()); endif;
      if($o_ArValorBN->getFechaeliminado()) : $this->setFechaeliminado($o_ArValorBN->getFechaeliminado()); endif;
      if($o_ArValorBN->getUsuarioeliminado()) : $this->setUsuarioeliminado($o_ArValorBN->getUsuarioeliminado()); endif;
      if($o_ArValorBN->getFecharegistro()) : $this->setFecharegistro($o_ArValorBN->getFecharegistro()); endif;
      if($o_ArValorBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_ArValorBN->getUsuarioregistro()); endif;
      if($o_ArValorBN->getUsuariomodificacion()) : $this->setUsuariomodificacion($o_ArValorBN->getUsuariomodificacion()); endif;
      if($o_ArValorBN->getFechamodificacion()) : $this->setFechamodificacion($o_ArValorBN->getFechamodificacion()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idvalor),(MAX(idvalor)+1), 1) AS Maximo FROM ar_valor;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = mysql_query($sql, $oLink);
      $row = mysql_fetch_array($result);
      $this->setIdvalor($row[0]);

      if($this->getIdvalor()){
        $a_Fields = array();

        if($this->getIdvalor()) : $a_Fields['idvalor'] = ($this->getIdvalor()); endif;
        if($this->getTipovalor()) : $a_Fields['tipovalor'] = ($this->getTipovalor()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getValor()) : $a_Fields['valor'] = ($this->getValor()); endif;
        if($this->getTopeminimo()) : $a_Fields['topeminimo'] = ($this->getTopeminimo()); endif;
        if($this->getTopemaximo()) : $a_Fields['topemaximo'] = ($this->getTopemaximo()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_valor (".$sStringField.") VALUES (".$sStringValue.");";
       $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdvalor())
      {
        $a_Fields = array();

        if($this->getIdvalor()) : $a_Fields['idvalor'] = ($this->getIdvalor()); endif;
        if($this->getTipovalor()) : $a_Fields['tipovalor'] = ($this->getTipovalor()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getValor()) : $a_Fields['valor'] = ($this->getValor()); endif;
        if($this->getTopeminimo()) : $a_Fields['topeminimo'] = ($this->getTopeminimo()); endif;
        if($this->getTopemaximo()) : $a_Fields['topemaximo'] = ($this->getTopemaximo()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_valor SET ".$sStringField." WHERE 1 AND idvalor='".$this->getIdvalor()."';";
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdvalor())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM ar_valor WHERE 1 AND idvalor='".$this->getIdvalor()."';"; 
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdvalor)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idvalor, tipovalor, descripcion, valor, topeminimo, topemaximo, estado, eliminado, fechaeliminado, usuarioeliminado, fecharegistro, usuarioregistro, usuariomodificacion, fechamodificacion FROM ar_valor WHERE 1 AND idvalor='".$vIdvalor."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArValorDP = new ArValorDP();
    $o_ArValorDP->setIdvalor($o_propel->idvalor);
    $o_ArValorDP->setTipovalor($o_propel->tipovalor);
    $o_ArValorDP->setDescripcion($o_propel->descripcion);
    $o_ArValorDP->setValor($o_propel->valor);
    $o_ArValorDP->setTopeminimo($o_propel->topeminimo);
    $o_ArValorDP->setTopemaximo($o_propel->topemaximo);
    $o_ArValorDP->setEstado($o_propel->estado);
    $o_ArValorDP->setEliminado($o_propel->eliminado);
    $o_ArValorDP->setFechaeliminado($o_propel->fechaeliminado);
    $o_ArValorDP->setUsuarioeliminado($o_propel->usuarioeliminado);
    $o_ArValorDP->setFecharegistro($o_propel->fecharegistro);
    $o_ArValorDP->setUsuarioregistro($o_propel->usuarioregistro);
    $o_ArValorDP->setUsuariomodificacion($o_propel->usuariomodificacion);
    $o_ArValorDP->setFechamodificacion($o_propel->fechamodificacion);
    return $o_ArValorDP;
  }
}