<?php
/**
 * Clase Base DP para BaseArCuentaDP
 *
 * @package    
 * @subpackage BaseArCuentaDP
 * @author     Willy
 * @version    SVN:: BaseArCuentaDP.class.php,v 1.1 2020-06-30 13:51:18 william.taype Exp $
 */
abstract class BaseArCuentaDP extends ArCuentaBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArCuentaBN )
    {
      $o_ArCuentaBN = $bSetDefault;
      if($o_ArCuentaBN->getIdcuenta()) : $this->setIdcuenta($o_ArCuentaBN->getIdcuenta()); endif;
      if($o_ArCuentaBN->getTipo()) : $this->setTipo($o_ArCuentaBN->getTipo()); endif;
      if($o_ArCuentaBN->getTitular()) : $this->setTitular($o_ArCuentaBN->getTitular()); endif;
      if($o_ArCuentaBN->getMoneda()) : $this->setMoneda($o_ArCuentaBN->getMoneda()); endif;
      if($o_ArCuentaBN->getNumero()) : $this->setNumero($o_ArCuentaBN->getNumero()); endif;
      if($o_ArCuentaBN->getIdbanco()) : $this->setIdbanco($o_ArCuentaBN->getIdbanco()); endif;
      if($o_ArCuentaBN->getEstado()) : $this->setEstado($o_ArCuentaBN->getEstado()); endif;
      if($o_ArCuentaBN->getEliminado()) : $this->setEliminado($o_ArCuentaBN->getEliminado()); endif;
      if($o_ArCuentaBN->getFechaeliminado()) : $this->setFechaeliminado($o_ArCuentaBN->getFechaeliminado()); endif;
      if($o_ArCuentaBN->getUsuarioeliminado()) : $this->setUsuarioeliminado($o_ArCuentaBN->getUsuarioeliminado()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idcuenta),(MAX(idcuenta)+1), 1) AS Maximo FROM ar_cuenta;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = mysql_query($sql, $oLink);
      $row = mysql_fetch_array($result);
      $this->setIdcuenta($row[0]);

      if($this->getIdcuenta()){
        $a_Fields = array();

        if($this->getIdcuenta()) : $a_Fields['idcuenta'] = ($this->getIdcuenta()); endif;
        if($this->getTipo()) : $a_Fields['tipo'] = ($this->getTipo()); endif;
        if($this->getTitular()) : $a_Fields['titular'] = ($this->getTitular()); endif;
        if($this->getMoneda()) : $a_Fields['moneda'] = ($this->getMoneda()); endif;
        if($this->getNumero()) : $a_Fields['numero'] = ($this->getNumero()); endif;
        if($this->getIdbanco()) : $a_Fields['idbanco'] = ($this->getIdbanco()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
		if($this->getFechacreacion()) : $a_Fields['Fechacreacion'] = ($this->getFechacreacion()); endif;
        if($this->getUsuariocreacion()) : $a_Fields['Usuariocreacion'] = ($this->getUsuariocreacion()); endif;
        if($this->getFechamodificacion()) : $a_Fields['Fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['Usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;


        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_cuenta (".$sStringField.") VALUES (".$sStringValue.");";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdcuenta())
      {
        $a_Fields = array();

        if($this->getIdcuenta()) : $a_Fields['idcuenta'] = ($this->getIdcuenta()); endif;
        if($this->getTipo()) : $a_Fields['tipo'] = ($this->getTipo()); endif;
        if($this->getTitular()) : $a_Fields['titular'] = ($this->getTitular()); endif;
        if($this->getMoneda()) : $a_Fields['moneda'] = ($this->getMoneda()); endif;
        if($this->getNumero()) : $a_Fields['numero'] = ($this->getNumero()); endif;
        if($this->getIdbanco()) : $a_Fields['idbanco'] = ($this->getIdbanco()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
		if($this->getFechacreacion()) : $a_Fields['Fechacreacion'] = ($this->getFechacreacion()); endif;
        if($this->getUsuariocreacion()) : $a_Fields['Usuariocreacion'] = ($this->getUsuariocreacion()); endif;
        if($this->getFechamodificacion()) : $a_Fields['Fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['Usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_cuenta SET ".$sStringField." WHERE 1 AND idcuenta='".$this->getIdcuenta()."';";
       $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdcuenta())
      {
        $a_Fields = array();
		
		if($this->getEliminado()) : $a_Fields['eliminado'] = (1); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
		
		$sStringField = arrayClass::implode_key_value(',', $a_Fields);
		
        $con = Conexion::getConexion();
        $sql = "UPDATE  ar_cuenta 
				SET $sStringField
				WHERE 1 AND idcuenta='".$this->getIdcuenta()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = mysql_query($sql, $oLink);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($oLink);
        }
        else
        {
          throw new Exception( mysql_error($oLink) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdcuenta)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idcuenta, tipo, titular, moneda, numero, idbanco, estado, eliminado, fechaeliminado, usuarioeliminado FROM ar_cuenta WHERE 1 AND idcuenta='".$vIdcuenta."'; ";
       $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArCuentaDP = new ArCuentaDP();
    $o_ArCuentaDP->setIdcuenta($o_propel->idcuenta);
    $o_ArCuentaDP->setTipo($o_propel->tipo);
    $o_ArCuentaDP->setTitular($o_propel->titular);
    $o_ArCuentaDP->setMoneda($o_propel->moneda);
    $o_ArCuentaDP->setNumero($o_propel->numero);
    $o_ArCuentaDP->setIdbanco($o_propel->idbanco);
    $o_ArCuentaDP->setEstado($o_propel->estado);
    $o_ArCuentaDP->setEliminado($o_propel->eliminado);
    $o_ArCuentaDP->setFechaeliminado($o_propel->fechaeliminado);
    $o_ArCuentaDP->setUsuarioeliminado($o_propel->usuarioeliminado);
    return $o_ArCuentaDP;
  }
}