<?php
/**
 * Clase Base DP para BaseArArqueoDetalleValorDP
 *
 * @package    
 * @subpackage BaseArArqueoDetalleValorDP
 * @author     Willy
 * @version    SVN:: BaseArArqueoDetalleValorDP.class.php,v 1.1 2020-06-30 13:51:18 william.taype Exp $
 */
abstract class BaseArArqueoDetalleValorDP extends ArArqueoDetalleValorBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArArqueoDetalleValorBN )
    {
      $o_ArArqueoDetalleValorBN = $bSetDefault;
      if($o_ArArqueoDetalleValorBN->getIdclase()) : $this->setIdclase($o_ArArqueoDetalleValorBN->getIdclase()); endif;
      if($o_ArArqueoDetalleValorBN->getIdsucursal()) : $this->setIdsucursal($o_ArArqueoDetalleValorBN->getIdsucursal()); endif;
      if($o_ArArqueoDetalleValorBN->getIdmercado()) : $this->setIdmercado($o_ArArqueoDetalleValorBN->getIdmercado()); endif;
      if($o_ArArqueoDetalleValorBN->getIdcolaborador()) : $this->setIdcolaborador($o_ArArqueoDetalleValorBN->getIdcolaborador()); endif;
      if($o_ArArqueoDetalleValorBN->getFecha()) : $this->setFecha($o_ArArqueoDetalleValorBN->getFecha()); endif;
      if($o_ArArqueoDetalleValorBN->getIdvalor()) : $this->setIdvalor($o_ArArqueoDetalleValorBN->getIdvalor()); endif;
      if($o_ArArqueoDetalleValorBN->getDescripcionvalor()) : $this->setDescripcionvalor($o_ArArqueoDetalleValorBN->getDescripcionvalor()); endif;
      if($o_ArArqueoDetalleValorBN->getValor()) : $this->setValor($o_ArArqueoDetalleValorBN->getValor()); endif;
      if($o_ArArqueoDetalleValorBN->getCantidad()) : $this->setCantidad($o_ArArqueoDetalleValorBN->getCantidad()); endif;
      if($o_ArArqueoDetalleValorBN->getSubtotal()) : $this->setSubtotal($o_ArArqueoDetalleValorBN->getSubtotal()); endif;
      if($o_ArArqueoDetalleValorBN->getFecharegistro()) : $this->setFecharegistro($o_ArArqueoDetalleValorBN->getFecharegistro()); endif;
      if($o_ArArqueoDetalleValorBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_ArArqueoDetalleValorBN->getUsuarioregistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
     
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdvalor()){
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdvalor()) : $a_Fields['idvalor'] = ($this->getIdvalor()); endif;
        if($this->getDescripcionvalor()) : $a_Fields['descripcionvalor'] = ($this->getDescripcionvalor()); endif;
        if($this->getValor()) : $a_Fields['valor'] = ($this->getValor()); endif;
        if($this->getCantidad()) : $a_Fields['cantidad'] = ($this->getCantidad()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_detalle_valor (".$sStringField.") VALUES (".$sStringValue.");";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }
  
  public function savelog()
  {
    try
    {
      $con = Conexion::getConexion();
     
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdvalor()){
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdvalor()) : $a_Fields['idvalor'] = ($this->getIdvalor()); endif;
        if($this->getDescripcionvalor()) : $a_Fields['descripcionvalor'] = ($this->getDescripcionvalor()); endif;
        if($this->getValor()) : $a_Fields['valor'] = ($this->getValor()); endif;
        if($this->getCantidad()) : $a_Fields['cantidad'] = ($this->getCantidad()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_detalle_valor_log (idlogdv,".$sStringField.") VALUES (null,".$sStringValue.");";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdvalor())
      {
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdvalor()) : $a_Fields['idvalor'] = ($this->getIdvalor()); endif;
        if($this->getDescripcionvalor()) : $a_Fields['descripcionvalor'] = ($this->getDescripcionvalor()); endif;
        if($this->getValor()) : $a_Fields['valor'] = ($this->getValor()); endif;
        if($this->getCantidad()) : $a_Fields['cantidad'] = ($this->getCantidad()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_arqueo_detalle_valor SET ".$sStringField." WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idvalor='".$this->getIdvalor()."';";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdvalor())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM ar_arqueo_detalle_valor WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idvalor='".$this->getIdvalor()."';"; 
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdclase, $vIdsucursal, $vIdmercado, $vIdcolaborador, $vFecha, $vIdvalor)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idclase, idsucursal, idmercado, idcolaborador, fecha, idvalor, descripcionvalor, valor, cantidad, subtotal, fecharegistro, usuarioregistro FROM ar_arqueo_detalle_valor WHERE 1 AND idclase='".$vIdclase."' AND idsucursal='".$vIdsucursal."' AND idmercado='".$vIdmercado."' AND idcolaborador='".$vIdcolaborador."' AND fecha='".$vFecha."' AND idvalor='".$vIdvalor."'; ";
      $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArArqueoDetalleValorDP = new ArArqueoDetalleValorDP();
    $o_ArArqueoDetalleValorDP->setIdclase($o_propel->idclase);
    $o_ArArqueoDetalleValorDP->setIdsucursal($o_propel->idsucursal);
    $o_ArArqueoDetalleValorDP->setIdmercado($o_propel->idmercado);
    $o_ArArqueoDetalleValorDP->setIdcolaborador($o_propel->idcolaborador);
    $o_ArArqueoDetalleValorDP->setFecha($o_propel->fecha);
    $o_ArArqueoDetalleValorDP->setIdvalor($o_propel->idvalor);
    $o_ArArqueoDetalleValorDP->setDescripcionvalor($o_propel->descripcionvalor);
    $o_ArArqueoDetalleValorDP->setValor($o_propel->valor);
    $o_ArArqueoDetalleValorDP->setCantidad($o_propel->cantidad);
    $o_ArArqueoDetalleValorDP->setSubtotal($o_propel->subtotal);
    $o_ArArqueoDetalleValorDP->setFecharegistro($o_propel->fecharegistro);
    $o_ArArqueoDetalleValorDP->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_ArArqueoDetalleValorDP;
  }
}