<?php
/**
 * Clase Base DP para BaseArArqueoCabeceraDP
 *
 * @package    
 * @subpackage BaseArArqueoCabeceraDP
 * @author     Willy
 * @version    SVN:: BaseArArqueoCabeceraDP.class.php,v 1.1 2020-06-30 13:51:18 william.taype Exp $
 */
abstract class BaseArArqueoCabeceraDP extends ArArqueoCabeceraBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArArqueoCabeceraBN )
    {
      $o_ArArqueoCabeceraBN = $bSetDefault;
      if($o_ArArqueoCabeceraBN->getIdclase()) : $this->setIdclase($o_ArArqueoCabeceraBN->getIdclase()); endif;
      if($o_ArArqueoCabeceraBN->getIdsucursal()) : $this->setIdsucursal($o_ArArqueoCabeceraBN->getIdsucursal()); endif;
      if($o_ArArqueoCabeceraBN->getIdmercado()) : $this->setIdmercado($o_ArArqueoCabeceraBN->getIdmercado()); endif;
      if($o_ArArqueoCabeceraBN->getIdcolaborador()) : $this->setIdcolaborador($o_ArArqueoCabeceraBN->getIdcolaborador()); endif;
      if($o_ArArqueoCabeceraBN->getFecha()) : $this->setFecha($o_ArArqueoCabeceraBN->getFecha()); endif;
      if($o_ArArqueoCabeceraBN->getDescripcionsucursal()) : $this->setDescripcionsucursal($o_ArArqueoCabeceraBN->getDescripcionsucursal()); endif;
      if($o_ArArqueoCabeceraBN->getDescripcionmercado()) : $this->setDescripcionmercado($o_ArArqueoCabeceraBN->getDescripcionmercado()); endif;
      if($o_ArArqueoCabeceraBN->getDescripcioncolaborador()) : $this->setDescripcioncolaborador($o_ArArqueoCabeceraBN->getDescripcioncolaborador()); endif;
      if($o_ArArqueoCabeceraBN->getEstado()) : $this->setEstado($o_ArArqueoCabeceraBN->getEstado()); endif;
      if($o_ArArqueoCabeceraBN->getFechacierre()) : $this->setFechacierre($o_ArArqueoCabeceraBN->getFechacierre()); endif;
      if($o_ArArqueoCabeceraBN->getTotal()) : $this->setTotal($o_ArArqueoCabeceraBN->getTotal()); endif;
      if($o_ArArqueoCabeceraBN->getFecharegistro()) : $this->setFecharegistro($o_ArArqueoCabeceraBN->getFecharegistro()); endif;
      if($o_ArArqueoCabeceraBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_ArArqueoCabeceraBN->getUsuarioregistro()); endif;
      if($o_ArArqueoCabeceraBN->getFechamodificacion()) : $this->setFechamodificacion($o_ArArqueoCabeceraBN->getFechamodificacion()); endif;
      if($o_ArArqueoCabeceraBN->getUsuariomodificacion()) : $this->setUsuariomodificacion($o_ArArqueoCabeceraBN->getUsuariomodificacion()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      

      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getMedio()){
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getMedio()) : $a_Fields['medio'] = ($this->getMedio()); endif;
        if($this->getDescripcionsucursal()) : $a_Fields['descripcionsucursal'] = ($this->getDescripcionsucursal()); endif;
        if($this->getDescripcionmercado()) : $a_Fields['descripcionmercado'] = ($this->getDescripcionmercado()); endif;
        if($this->getDescripcioncolaborador()) : $a_Fields['descripcioncolaborador'] = ($this->getDescripcioncolaborador()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getFechacierre()) : $a_Fields['fechacierre'] = ($this->getFechacierre()); endif;
        if($this->getTotal()) : $a_Fields['total'] = ($this->getTotal()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getIdgastoreferencia()) : $a_Fields['idgastoreferencia'] = ($this->getIdgastoreferencia()); endif;

        
        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_cabecera (".$sStringField.") VALUES (".$sStringValue.");";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }
  
  public function savelog()
  {
    try
    {
      $con = Conexion::getConexion();
      

      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getMedio()){
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getMedio()) : $a_Fields['medio'] = ($this->getMedio()); endif;
        if($this->getDescripcionsucursal()) : $a_Fields['descripcionsucursal'] = ($this->getDescripcionsucursal()); endif;
        if($this->getDescripcionmercado()) : $a_Fields['descripcionmercado'] = ($this->getDescripcionmercado()); endif;
        if($this->getDescripcioncolaborador()) : $a_Fields['descripcioncolaborador'] = ($this->getDescripcioncolaborador()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getFechacierre()) : $a_Fields['fechacierre'] = ($this->getFechacierre()); endif;
        if($this->getTotal()) : $a_Fields['total'] = ($this->getTotal()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getIdgastoreferencia()) : $a_Fields['idgastoreferencia'] = ($this->getIdgastoreferencia()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_cabecera_log (idlogac,".$sStringField.") VALUES (null,".$sStringValue.");";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }
  
  public function update()
  {
    try
    {
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getMedio())
      {
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getMedio()) : $a_Fields['medio'] = ($this->getMedio()); endif;
        if($this->getDescripcionsucursal()) : $a_Fields['descripcionsucursal'] = ($this->getDescripcionsucursal()); endif;
        if($this->getDescripcionmercado()) : $a_Fields['descripcionmercado'] = ($this->getDescripcionmercado()); endif;
        if($this->getDescripcioncolaborador()) : $a_Fields['descripcioncolaborador'] = ($this->getDescripcioncolaborador()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getFechacierre()) : $a_Fields['fechacierre'] = ($this->getFechacierre()); endif;
        if($this->getTotal()) : $a_Fields['total'] = ($this->getTotal()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getIdgastoreferencia()) : $a_Fields['idgastoreferencia'] = ($this->getIdgastoreferencia()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_arqueo_cabecera SET ".$sStringField." WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND medio='".$this->getMedio()."' ;";
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getMedio() )
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM ar_arqueo_cabecera WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND medio='".$this->getMedio()."';"; 
        $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
        if($result)
        {
          $this->nRowsAffected = (int) mysql_affected_rows($con);
        }
        else
        {
          throw new Exception( mysql_error($con) );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdclase, $vIdsucursal, $vIdmercado, $vIdcolaborador, $vFecha, $vMedio)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idclase, idsucursal, idmercado, idcolaborador, fecha, medio, descripcionsucursal, descripcionmercado, descripcioncolaborador, estado, fechacierre, total, fecharegistro, usuarioregistro, fechamodificacion, usuariomodificacion FROM ar_arqueo_cabecera WHERE 1 AND idclase='".$vIdclase."' AND idsucursal='".$vIdsucursal."' AND idmercado='".$vIdmercado."' AND idcolaborador='".$vIdcolaborador."' AND fecha='".$vFecha."' AND medio='".$vMedio."'; ";
       $result = mysql_db_query(Conexion::getNameDb(), $sql, $con);
      $o_Propel = $result ? mysql_fetch_object($result) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArArqueoCabeceraDP = new ArArqueoCabeceraDP();
    $o_ArArqueoCabeceraDP->setIdclase($o_propel->idclase);
    $o_ArArqueoCabeceraDP->setIdsucursal($o_propel->idsucursal);
    $o_ArArqueoCabeceraDP->setIdmercado($o_propel->idmercado);
    $o_ArArqueoCabeceraDP->setIdcolaborador($o_propel->idcolaborador);
    $o_ArArqueoCabeceraDP->setFecha($o_propel->fecha);
    $o_ArArqueoCabeceraDP->setMedio($o_propel->medio);
    $o_ArArqueoCabeceraDP->setDescripcionsucursal($o_propel->descripcionsucursal);
    $o_ArArqueoCabeceraDP->setDescripcionmercado($o_propel->descripcionmercado);
    $o_ArArqueoCabeceraDP->setDescripcioncolaborador($o_propel->descripcioncolaborador);
    $o_ArArqueoCabeceraDP->setEstado($o_propel->estado);
    $o_ArArqueoCabeceraDP->setFechacierre($o_propel->fechacierre);
    $o_ArArqueoCabeceraDP->setTotal($o_propel->total);
    $o_ArArqueoCabeceraDP->setFecharegistro($o_propel->fecharegistro);
    $o_ArArqueoCabeceraDP->setUsuarioregistro($o_propel->usuarioregistro);
    $o_ArArqueoCabeceraDP->setFechamodificacion($o_propel->fechamodificacion);
    $o_ArArqueoCabeceraDP->setUsuariomodificacion($o_propel->usuariomodificacion);
    $o_ArArqueoCabeceraDP->setIdgastoreferencia($o_propel->idgastoreferencia);
    return $o_ArArqueoCabeceraDP;
  }
}